/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin.autoconfigure;

import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.VaadinServiceInitListener;
import de.codecamp.messages.spring.ExtendedMessageSource;
import de.codecamp.messages.spring.autoconfigure.MessagesAutoConfiguration;
import de.codecamp.messages.spring.vaadin.MessageSourceI18NProvider;
import de.codecamp.messages.spring.vaadin.VaadinMessageAccessor;
import de.codecamp.messages.spring.vaadin.VaadinSessionLocaleServiceInitListener;
import de.codecamp.messages.spring.vaadin.security.LocaleAndTimeZoneExtractor;
import de.codecamp.messages.spring.vaadin.security.PostAuthenticationSessionLocaleHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;

@Configuration
@AutoConfigureAfter(value={MessagesAutoConfiguration.class})
@EnableConfigurationProperties
public class MessagesVaadinAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    I18NProvider vaadinI18NProvider(ExtendedMessageSource messageSource) {
        MessageSourceI18NProvider bean = new MessageSourceI18NProvider();
        bean.setMessageSource(messageSource);
        return bean;
    }

    @Bean
    VaadinServiceInitListener vaadinSessionLocaleServiceInitListener() {
        return new VaadinSessionLocaleServiceInitListener();
    }

    @Bean
    VaadinMessageAccessor vaadinMessageAccessor() {
        return new VaadinMessageAccessor();
    }

    @Configuration
    @ConditionalOnClass(value={AbstractAuthenticationEvent.class})
    static class PostAuthenticationSessionLocaleHandlerConfig {
        PostAuthenticationSessionLocaleHandlerConfig() {
        }

        @Bean
        PostAuthenticationSessionLocaleHandler vaadinPostAuthenticationSessionLocaleHandler(@Autowired(required=false) LocaleAndTimeZoneExtractor localeAndTimeZoneExtractor) {
            PostAuthenticationSessionLocaleHandler bean = new PostAuthenticationSessionLocaleHandler();
            if (localeAndTimeZoneExtractor != null) {
                bean.setLocaleAndTimeZoneExtractor(localeAndTimeZoneExtractor);
            }
            return bean;
        }
    }
}

