/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.VaadinService;
import de.codecamp.messages.spring.MessageAccessor;
import de.codecamp.messages.spring.vaadin.MessageSourceI18NProvider;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class VaadinMessageAccessor
implements MessageAccessor,
Serializable {
    private final Locale locale;

    public VaadinMessageAccessor() {
        this.locale = null;
    }

    private VaadinMessageAccessor(Locale locale) {
        this.locale = Objects.requireNonNull(locale, "locale must not be null");
    }

    public Set<Locale> getAvailableLocales() {
        I18NProvider i18nProvider = this.getI18NProvider();
        if (i18nProvider instanceof MessageSourceI18NProvider) {
            return ((MessageSourceI18NProvider)i18nProvider).getMessageSource().getAvailableLocales();
        }
        return new HashSet<Locale>(i18nProvider.getProvidedLocales());
    }

    public Locale getDefaultLocale() {
        I18NProvider i18nProvider = this.getI18NProvider();
        if (i18nProvider instanceof MessageSourceI18NProvider) {
            return ((MessageSourceI18NProvider)i18nProvider).getMessageSource().getDefaultLocale();
        }
        return (Locale)this.getI18NProvider().getProvidedLocales().get(0);
    }

    public Locale getLocale() {
        return Optional.ofNullable(this.locale).orElseGet(() -> this.getCurrentUI().getLocale());
    }

    public String getMessage(String messageKey, Object ... args) {
        return this.getCurrentUI().getTranslation(this.getLocale(), messageKey, args);
    }

    public MessageAccessor forLocale(Locale locale) {
        return new VaadinMessageAccessor(locale);
    }

    private I18NProvider getI18NProvider() {
        return Objects.requireNonNull(VaadinService.getCurrent(), "No current VaadinService found.").getInstantiator().getI18NProvider();
    }

    private UI getCurrentUI() {
        return Objects.requireNonNull(UI.getCurrent(), "No current UI found.");
    }
}

