/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.i18n.I18NProvider;
import de.codecamp.messages.ResolvableMessage;
import de.codecamp.messages.spring.ExtendedMessageSource;
import de.codecamp.messages.spring.vaadin.VaadinLocale;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.context.NoSuchMessageException;

public class MessageSourceI18NProvider
implements I18NProvider {
    private ExtendedMessageSource messageSource;

    ExtendedMessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(ExtendedMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public List<Locale> getProvidedLocales() {
        Set availableLocales = this.messageSource.getAvailableLocales();
        Locale defaultLocale = this.messageSource.getDefaultLocale();
        ArrayList<Locale> providedLocales = new ArrayList<Locale>(availableLocales.size());
        if (defaultLocale != null) {
            providedLocales.add(defaultLocale);
        }
        for (Locale locale : availableLocales) {
            if (locale.equals(defaultLocale)) continue;
            providedLocales.add(locale);
        }
        return providedLocales;
    }

    public String getTranslation(String key, Locale locale, Object ... params) {
        try {
            if (params != null && params.length == 1 && params[0] instanceof Map) {
                Map args = (Map)params[0];
                return this.messageSource.getMessage(key, args, locale, VaadinLocale.getTimeZone());
            }
            return this.messageSource.getMessage(key, params, locale, VaadinLocale.getTimeZone());
        }
        catch (NoSuchMessageException ex) {
            return "!" + key + "!";
        }
    }

    public String getTranslation(Object key, Locale locale, Object ... params) {
        try {
            if (key instanceof ResolvableMessage) {
                ResolvableMessage rm = (ResolvableMessage)key;
                if (params != null && params.length > 0) {
                    throw new IllegalArgumentException("ResolvableMessages do not support additional message arguments.");
                }
                return this.messageSource.getMessage(rm, locale, VaadinLocale.getTimeZone());
            }
            if (params != null && params.length == 1 && params[0] instanceof Map) {
                Map args = (Map)params[0];
                return this.messageSource.getMessage(key.toString(), args, locale, VaadinLocale.getTimeZone());
            }
            return this.messageSource.getMessage(key.toString(), params, locale, VaadinLocale.getTimeZone());
        }
        catch (NoSuchMessageException ex) {
            return "!" + key + "!";
        }
    }
}

