/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinSession;
import de.codecamp.messages.spring.vaadin.LocalizationUtils;
import de.codecamp.messages.spring.vaadin.SessionLocaleUtils;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;

public class VaadinLocale {
    private VaadinLocale() {
    }

    public static Locale getLocale() {
        return VaadinLocale.getLocaleNoDefault().orElse(LocalizationUtils.getL10n().getDefaultLocale());
    }

    public static ZoneId getTimeZone() {
        return VaadinLocale.getTimeZoneNoDefault().orElse(LocalizationUtils.getL10n().getDefaultTimeZone());
    }

    public static Optional<Locale> getLocaleNoDefault() {
        UI ui = UI.getCurrent();
        if (ui != null) {
            return Optional.of(ui.getLocale());
        }
        VaadinSession session = VaadinSession.getCurrent();
        if (session != null) {
            return Optional.of(session.getLocale());
        }
        return Optional.empty();
    }

    public static Optional<ZoneId> getTimeZoneNoDefault() {
        ZoneId timeZone;
        VaadinSession session = VaadinSession.getCurrent();
        if (session != null && (timeZone = SessionLocaleUtils.getTimeZone(session)) != null) {
            return Optional.of(timeZone);
        }
        return Optional.empty();
    }
}

