/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin.security;

import com.vaadin.flow.server.VaadinSession;
import de.codecamp.messages.spring.vaadin.SessionLocaleUtils;
import de.codecamp.messages.spring.vaadin.security.HasLocaleAndTimeZone;
import de.codecamp.messages.spring.vaadin.security.LocaleAndTimeZoneExtractor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class PostAuthenticationSessionLocaleHandler {
    private List<LocaleAndTimeZoneExtractor> localeAndTimeZoneExtractors;

    public void setLocaleAndTimeZoneExtractors(List<LocaleAndTimeZoneExtractor> localeAndTimeZoneExtractors) {
        this.localeAndTimeZoneExtractors = localeAndTimeZoneExtractors;
    }

    @EventListener(value={AuthenticationSuccessEvent.class, InteractiveAuthenticationSuccessEvent.class})
    public void onAuthenticationSuccess(AbstractAuthenticationEvent event) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        AtomicReference locale = new AtomicReference();
        AtomicReference timeZone = new AtomicReference();
        Object object = event.getAuthentication().getPrincipal();
        if (object instanceof HasLocaleAndTimeZone) {
            HasLocaleAndTimeZone hasLocaleAndTimeZone = (HasLocaleAndTimeZone)object;
            hasLocaleAndTimeZone.getLocale().ifPresent(locale::set);
            hasLocaleAndTimeZone.getTimeZone().ifPresent(timeZone::set);
        }
        if (this.localeAndTimeZoneExtractors != null && (locale.get() == null || timeZone.get() == null)) {
            for (LocaleAndTimeZoneExtractor localeAndTimeZoneExtractor : this.localeAndTimeZoneExtractors) {
                if (locale.get() == null) {
                    localeAndTimeZoneExtractor.getLocale(event.getAuthentication()).ifPresent(locale::set);
                }
                if (timeZone.get() == null) {
                    localeAndTimeZoneExtractor.getTimeZone(event.getAuthentication()).ifPresent(timeZone::set);
                }
                if (locale.get() == null || timeZone.get() == null) continue;
                break;
            }
        }
        if (locale.get() == null && timeZone.get() == null) {
            return;
        }
        PostAuthenticationSessionLocaleHandler.getVaadinSessions(requestAttributes.getRequest()).forEach(session -> {
            if (locale.get() != null) {
                SessionLocaleUtils.setLocale(session, (Locale)locale.get());
            }
            if (timeZone.get() != null) {
                SessionLocaleUtils.setTimeZone(session, (TimeZone)timeZone.get());
            }
        });
    }

    private static Stream<VaadinSession> getVaadinSessions(HttpServletRequest request) {
        HttpSession httpSession = request.getSession(false);
        if (httpSession == null) {
            return Stream.empty();
        }
        return VaadinSession.getAllSessions((HttpSession)httpSession).stream();
    }
}

