/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public final class SessionLocaleUtils {
    private SessionLocaleUtils() {
    }

    public static Locale getLocale() {
        VaadinSession session = Objects.requireNonNull(VaadinSession.getCurrent(), "No current VaadinSession found.");
        return SessionLocaleUtils.getLocale(session);
    }

    public static void setLocale(Locale locale) {
        VaadinSession session = Objects.requireNonNull(VaadinSession.getCurrent(), "No current VaadinSession found.");
        SessionLocaleUtils.setLocale(session, locale);
    }

    public static Locale getLocale(VaadinSession session) {
        Objects.requireNonNull(session, "session must not be null");
        AtomicReference localeHolder = new AtomicReference();
        session.access((Command & Serializable)() -> localeHolder.set(session.getLocale()));
        return (Locale)localeHolder.get();
    }

    public static void setLocale(VaadinSession session, Locale locale) {
        Objects.requireNonNull(session, "session must not be null");
        session.access((Command & Serializable)() -> session.setLocale(locale));
    }

    public static ZoneId getTimeZone() {
        VaadinSession session = Objects.requireNonNull(VaadinSession.getCurrent(), "No current VaadinSession found.");
        return SessionLocaleUtils.getTimeZone(session);
    }

    public static void setTimeZone(ZoneId timeZone) {
        VaadinSession session = Objects.requireNonNull(VaadinSession.getCurrent(), "No current VaadinSession found.");
        SessionLocaleUtils.setTimeZone(session, timeZone);
    }

    public static void setTimeZone(TimeZone timeZone) {
        SessionLocaleUtils.setTimeZone(timeZone == null ? null : timeZone.toZoneId());
    }

    public static ZoneId getTimeZone(VaadinSession session) {
        Objects.requireNonNull(session, "session must not be null");
        if (session.hasLock()) {
            return (ZoneId)session.getAttribute(ZoneId.class);
        }
        AtomicReference timeZoneHolder = new AtomicReference();
        session.accessSynchronously((Command & Serializable)() -> timeZoneHolder.set((ZoneId)session.getAttribute(ZoneId.class)));
        return (ZoneId)timeZoneHolder.get();
    }

    public static void setTimeZone(VaadinSession session, ZoneId timeZone) {
        Objects.requireNonNull(session, "session must not be null");
        if (session.hasLock()) {
            session.setAttribute(ZoneId.class, (Object)timeZone);
        } else {
            session.access((Command & Serializable)() -> session.setAttribute(ZoneId.class, (Object)timeZone));
        }
    }

    public static void setTimeZone(VaadinSession session, TimeZone timeZone) {
        SessionLocaleUtils.setTimeZone(session, timeZone == null ? null : timeZone.toZoneId());
    }
}

