/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinSession;
import de.codecamp.messages.spring.vaadin.SessionLocaleUtils;
import java.time.ZoneId;
import java.util.Locale;

public final class VaadinLocale {
    private VaadinLocale() {
    }

    public static Locale getLocale() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            throw new IllegalStateException("No current Vaadin UI or session found.");
        }
        UI ui = UI.getCurrent();
        if (ui != null) {
            return ui.getLocale();
        }
        return session.getLocale();
    }

    public static ZoneId getTimeZone() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            throw new IllegalStateException("No current Vaadin UI or session found.");
        }
        ZoneId timeZone = SessionLocaleUtils.getTimeZone(session);
        if (timeZone != null) {
            return timeZone;
        }
        return ZoneId.systemDefault();
    }
}

