/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.spring.vaadin;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import de.codecamp.messages.spring.vaadin.SessionLocaleUtils;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.TimeZone;

public class VaadinSessionLocaleServiceInitListener
implements VaadinServiceInitListener {
    public void serviceInit(ServiceInitEvent serviceInitEvent) {
        serviceInitEvent.getSource().addUIInitListener((UIInitListener & Serializable)uiInitEvent -> {
            UI ui = uiInitEvent.getUI();
            VaadinSession session = ui.getSession();
            if (session.getAttribute(ZoneId.class) == null) {
                ui.getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                    String timeZoneId = details.getTimeZoneId();
                    if (timeZoneId != null) {
                        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
                        SessionLocaleUtils.setTimeZone(session, timeZone);
                    }
                });
            }
        });
    }
}

