package de.codecamp.tracer.impl;

import java.util.UUID;

import de.codecamp.tracer.ActiveTrace;
import de.codecamp.tracer.TraceContext;


public class NoOpTraceContext
  implements
    TraceContext
{

  public static final TraceContext INSTANCE = new NoOpTraceContext();

  private static final UUID ID = UUID.fromString("00000000-0000-0000-0000-000000000000");


  private NoOpTraceContext()
  {
  }


  @Override
  public UUID getId()
  {
    return ID;
  }

  @Override
  public boolean isRootContext()
  {
    return true;
  }

  @Override
  public void setExitThrowable(Throwable exitThrowable)
  {
  }

  @Override
  public ActiveTrace startTrace(String label, Object... labelFormatArgs)
  {
    return NoOpActiveTrace.INSTANCE;
  }

  @Override
  public ActiveTrace getActiveTrace()
  {
    return NoOpActiveTrace.INSTANCE;
  }

  @Override
  public void close()
  {
  }

}
