/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer.impl;

import de.codecamp.tracer.Trace;
import de.codecamp.tracer.TraceContext;
import de.codecamp.tracer.TraceContextListener;
import de.codecamp.tracer.TraceHandler;
import de.codecamp.tracer.Tracer;
import de.codecamp.tracer.impl.CludeFilter;
import de.codecamp.tracer.impl.FilterMode;
import de.codecamp.tracer.impl.NoOpTraceContext;
import de.codecamp.tracer.impl.PatternFilterSet;
import de.codecamp.tracer.impl.TraceContextImpl;
import de.codecamp.tracer.impl.WarnFilter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class TracerImpl
implements Tracer {
    private static final Logger LOG = Logger.getLogger(TracerImpl.class.getName());
    private boolean gapsIncluded = true;
    private Duration gapsThreshold = Duration.ZERO;
    private PatternFilterSet<CludeFilter> includes;
    private PatternFilterSet<CludeFilter> excludes;
    private PatternFilterSet<WarnFilter> warnThresholds;
    private List<TraceContextListener> listeners;
    private TraceHandler handler;

    public boolean isGapsIncluded() {
        return this.gapsIncluded;
    }

    public void setGapsIncluded(boolean gapsIncluded) {
        this.gapsIncluded = gapsIncluded;
    }

    public Duration getGapsThreshold() {
        return this.gapsThreshold;
    }

    public void setGapsThreshold(Duration gapsThreshold) {
        this.gapsThreshold = gapsThreshold;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes == null ? null : new PatternFilterSet<CludeFilter>(this.toCludeFilters(includes));
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes == null ? null : new PatternFilterSet<CludeFilter>(this.toCludeFilters(excludes));
    }

    private List<CludeFilter> toCludeFilters(String[] includesOrExcludes) {
        return Stream.of(includesOrExcludes).map(String::trim).map(pattern -> {
            boolean transitive = false;
            if (pattern.endsWith("!")) {
                transitive = true;
                pattern = StringUtils.removeEnd((String)pattern, (String)"!").trim();
            }
            return new CludeFilter((String)pattern, transitive);
        }).collect(Collectors.toList());
    }

    public void setWarnThresholds(Map<String, Duration> warnThresholds) {
        if (warnThresholds == null) {
            this.warnThresholds = null;
            return;
        }
        ArrayList filters = new ArrayList();
        warnThresholds.forEach((pattern, threshold) -> {
            pattern = pattern.trim();
            filters.add(new WarnFilter((String)pattern, (Duration)threshold));
        });
        this.warnThresholds = new PatternFilterSet(filters);
    }

    public TraceHandler getHandler() {
        return this.handler;
    }

    public void setHandler(TraceHandler handler) {
        this.handler = handler;
    }

    public List<TraceContextListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<TraceContextListener> listeners) {
        this.listeners = listeners != null ? new CopyOnWriteArrayList<TraceContextListener>(listeners) : null;
    }

    @Override
    public TraceContext openContext(String fullContextName, String contextLabel, Object ... labelFormatArgs) {
        TraceContext newContext;
        Optional<CludeFilter> result;
        if (fullContextName == null) {
            throw new IllegalArgumentException("fullContextName must not be null");
        }
        if (contextLabel == null) {
            throw new IllegalArgumentException("contextLabel must not be null");
        }
        ArrayList<TraceContextListener> listenersCopy = null;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            listenersCopy = new ArrayList<TraceContextListener>(this.listeners);
        }
        FilterMode transitiveAncestorMode = null;
        TraceContextImpl parentContext = null;
        if (TraceContextImpl.CURRENT_CONTEXT.get() instanceof TraceContextImpl) {
            for (TraceContextImpl ancestorContext = parentContext = (TraceContextImpl)TraceContextImpl.CURRENT_CONTEXT.get(); ancestorContext != null; ancestorContext = ancestorContext.getParentContext()) {
                if (!ancestorContext.getFilterMode().isTransitive()) continue;
                transitiveAncestorMode = ancestorContext.getFilterMode();
                break;
            }
        }
        FilterMode filterMode = this.includes == null ? (transitiveAncestorMode != null ? transitiveAncestorMode : FilterMode.INCLUDED_TRANSITIVELY) : ((result = this.includes.filter(fullContextName)).isPresent() ? (result.get().isTransitive() ? FilterMode.INCLUDED_TRANSITIVELY : (transitiveAncestorMode == null || transitiveAncestorMode.isExcluded() ? FilterMode.INCLUDED : transitiveAncestorMode)) : (transitiveAncestorMode != null ? transitiveAncestorMode : FilterMode.EXCLUDED_TRANSITIVELY));
        if (this.excludes != null && (result = this.excludes.filter(fullContextName)).isPresent()) {
            if (result.get().isTransitive()) {
                filterMode = FilterMode.EXCLUDED_TRANSITIVELY;
            } else if (filterMode == null || filterMode.isIncluded()) {
                filterMode = FilterMode.EXCLUDED;
            }
        }
        if (parentContext == null && filterMode.isExcluded()) {
            newContext = NoOpTraceContext.INSTANCE;
        } else {
            TraceContextImpl newContextImpl;
            switch (filterMode) {
                case EXCLUDED_TRANSITIVELY: {
                    newContextImpl = TraceContextImpl.newExcludedTransitively(this, parentContext, fullContextName);
                    break;
                }
                case EXCLUDED: {
                    newContextImpl = TraceContextImpl.newExcluded(this, parentContext, fullContextName);
                    break;
                }
                case INCLUDED: {
                    newContextImpl = TraceContextImpl.newIncluded(this, parentContext, fullContextName, contextLabel, labelFormatArgs);
                    break;
                }
                default: {
                    newContextImpl = TraceContextImpl.newIncludedTransitively(this, parentContext, fullContextName, contextLabel, labelFormatArgs);
                }
            }
            newContext = newContextImpl;
            TraceContextImpl.CURRENT_CONTEXT.set(newContext);
            if (listenersCopy != null) {
                for (TraceContextListener listener : listenersCopy) {
                    try {
                        listener.contextOpened(newContext);
                    }
                    catch (RuntimeException ex) {
                        LOG.log(Level.SEVERE, "An error occurred during context-started-notification.", ex);
                    }
                }
            }
        }
        return newContext;
    }

    public void checkWarnThreshold(TraceContextImpl context) {
        if (this.warnThresholds == null) {
            return;
        }
        Optional<WarnFilter> filter = this.warnThresholds.filter(context.getName());
        if (!filter.isPresent()) {
            return;
        }
        Trace rootTrace = context.getRootTrace();
        if (rootTrace.getDuration().compareTo(filter.get().getThreshold()) >= 0) {
            rootTrace.setWarn(true);
        }
    }
}

