/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer.handlers;

import de.codecamp.tracer.AbstractTraceHandler;
import de.codecamp.tracer.Trace;
import de.codecamp.tracer.TraceFormatter;
import java.util.logging.Logger;

public class JulLoggingTraceHandler
extends AbstractTraceHandler {
    private final Logger logger;
    private TraceFormatter formatter;

    public JulLoggingTraceHandler() {
        this("de.codecamp.tracer");
    }

    public JulLoggingTraceHandler(String loggerName) {
        this.logger = Logger.getLogger(loggerName);
    }

    public void setFormatter(TraceFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public void handle(Trace trace) {
        if (this.containsWarnings(trace)) {
            this.logger.warning(this.formatter.format(trace));
        } else {
            this.logger.fine(this.formatter.format(trace));
        }
    }
}

