/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;

public class ParamListArg {
    private static final Set<String> PRINTABLE_TYPES = Set.of(Locale.class.getName());
    private final Object[] params;

    public ParamListArg(Object ... params) {
        this.params = (Object[])params.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.params.length * 16);
        boolean first = true;
        for (Object param : this.params) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (param == null || param.getClass().isPrimitive() || param.getClass().getName().startsWith("java.lang") || param.getClass().isEnum() || PRINTABLE_TYPES.contains(param.getClass().getName())) {
                if (param instanceof String) {
                    sb.append("'").append(param).append("'");
                    continue;
                }
                sb.append(param);
                continue;
            }
            if (param instanceof Collection) {
                Collection collection = (Collection)param;
                sb.append(param.getClass().getSimpleName()).append("(").append(collection.size()).append(")");
                continue;
            }
            boolean isArray = param.getClass().isArray();
            boolean isJavaLangElements = false;
            if (isArray) {
                isJavaLangElements = param.getClass().getComponentType().getName().startsWith("java.lang");
            }
            if (isArray && isJavaLangElements) {
                sb.append(Arrays.toString((Object[])param));
                continue;
            }
            sb.append(param.getClass().getSimpleName());
        }
        return sb.toString();
    }
}

