/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer.impl;

import de.codecamp.tracer.ActiveTrace;
import de.codecamp.tracer.Trace;
import de.codecamp.tracer.TraceContext;
import de.codecamp.tracer.TraceContextListener;
import de.codecamp.tracer.impl.ActiveTraceImpl;
import de.codecamp.tracer.impl.FilterMode;
import de.codecamp.tracer.impl.NoOpActiveTrace;
import de.codecamp.tracer.impl.TracerImpl;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TraceContextImpl
implements TraceContext {
    public static final ThreadLocal<TraceContext> CURRENT_CONTEXT = new ThreadLocal();
    private static final Logger LOG = Logger.getLogger(TraceContextImpl.class.getName());
    private final UUID id = UUID.randomUUID();
    private final String name;
    private final TraceContextImpl parentContext;
    private final FilterMode filterMode;
    private final Trace rootTrace;
    private final TracerImpl tracer;
    private Throwable exitThrowable;
    private boolean isClosed;

    private TraceContextImpl(TracerImpl tracer, TraceContextImpl parentContext, String name, String label, Object[] nameFormatArgs, FilterMode filterMode) {
        this.tracer = tracer;
        this.parentContext = parentContext;
        this.name = name;
        Trace parentTrace = null;
        if (parentContext != null && (parentTrace = parentContext.getRootTrace().getActiveTrace(true)) == null) {
            throw new IllegalStateException("No active trace found in parent context.");
        }
        this.filterMode = filterMode;
        this.rootTrace = parentContext != null && filterMode.isExcluded() ? parentTrace : Trace.newContextRoot(parentTrace, Instant.now(), label, nameFormatArgs);
    }

    static TraceContextImpl newIncluded(TracerImpl tracer, TraceContextImpl parentContext, String contextName, String label, Object ... nameFormatArgs) {
        return new TraceContextImpl(tracer, parentContext, contextName, label, nameFormatArgs, FilterMode.INCLUDED);
    }

    static TraceContextImpl newIncludedTransitively(TracerImpl tracer, TraceContextImpl parentContext, String contextName, String label, Object ... nameFormatArgs) {
        return new TraceContextImpl(tracer, parentContext, contextName, label, nameFormatArgs, FilterMode.INCLUDED_TRANSITIVELY);
    }

    static TraceContextImpl newExcluded(TracerImpl tracer, TraceContextImpl parentContext, String contextName) {
        return new TraceContextImpl(tracer, parentContext, contextName, null, null, FilterMode.EXCLUDED);
    }

    static TraceContextImpl newExcludedTransitively(TracerImpl tracer, TraceContextImpl parentContext, String contextName) {
        return new TraceContextImpl(tracer, parentContext, contextName, null, null, FilterMode.EXCLUDED_TRANSITIVELY);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TraceContextImpl getParentContext() {
        return this.parentContext;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public Trace getRootTrace() {
        return this.rootTrace;
    }

    private boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isRootContext() {
        return this.parentContext == null;
    }

    @Override
    public void setExitThrowable(Throwable exitThrowable) {
        this.exitThrowable = exitThrowable;
    }

    @Override
    public TraceContext openContext(String fullContextName, String contextLabel, Object ... labelFormatArgs) {
        return this.tracer.openContext(fullContextName, contextLabel, labelFormatArgs);
    }

    @Override
    public ActiveTrace startTrace(String label, Object ... labelFormatArgs) {
        if (this.isClosed()) {
            throw new IllegalStateException("trace context was already closed");
        }
        if (this.filterMode.isExcluded()) {
            return NoOpActiveTrace.INSTANCE;
        }
        return TraceContextImpl.doStartTrace(this.tracer, this.getRootTrace(), label, labelFormatArgs);
    }

    static ActiveTrace doStartTrace(TracerImpl tracer, Trace parentTrace, String label, Object ... labelFormatArgs) {
        Trace subTrace;
        Instant now = Instant.now();
        Trace lastSubTrace = parentTrace.getLastSubTrace();
        if (lastSubTrace != null && !lastSubTrace.hasEnded()) {
            lastSubTrace.end(now);
            subTrace = Trace.newExplicit(parentTrace, now, label, labelFormatArgs);
        } else {
            Instant previousBoundary;
            if (tracer.isGapsIncluded() && (previousBoundary = lastSubTrace != null ? lastSubTrace.getEndTime() : parentTrace.getStartTime()).isBefore(now) && Duration.between(previousBoundary, now).abs().compareTo(tracer.getGapsThreshold()) >= 0) {
                Trace.newGap(parentTrace, previousBoundary, now);
            }
            subTrace = Trace.newExplicit(parentTrace, now, label, labelFormatArgs);
        }
        return new ActiveTraceImpl(subTrace, tracer);
    }

    @Override
    public ActiveTrace getActiveTrace() {
        Trace activeTrace = this.getRootTrace().getActiveTrace(true);
        return activeTrace != null ? new ActiveTraceImpl(activeTrace, this.tracer) : NoOpActiveTrace.INSTANCE;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            throw new IllegalStateException("trace context was already closed");
        }
        TraceContext context = CURRENT_CONTEXT.get();
        if (context != this) {
            throw new IllegalStateException("inconsistent state; this TraceContext is expected to be the current TraceContext");
        }
        if (this.parentContext == null) {
            CURRENT_CONTEXT.remove();
        } else {
            CURRENT_CONTEXT.set(this.parentContext);
        }
        if (this.getFilterMode().isIncluded()) {
            Instant previousBoundary;
            Instant endTime = Instant.now();
            Trace lastSubTrace = this.getRootTrace().getLastSubTrace();
            if (lastSubTrace != null && lastSubTrace.hasEnded() && this.tracer.isGapsIncluded() && (previousBoundary = lastSubTrace.getEndTime()).isBefore(endTime)) {
                Trace.newGap(this.getRootTrace(), previousBoundary, endTime);
            }
            this.getRootTrace().end(endTime, this.exitThrowable);
            this.tracer.checkWarnThreshold(this);
        }
        this.isClosed = true;
        if (this.tracer.getListeners() != null) {
            for (TraceContextListener listener : this.tracer.getListeners()) {
                try {
                    listener.contextClosed(context);
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.SEVERE, "An error occurred during context-closed-notification.", ex);
                }
            }
        }
        if (this.tracer.getHandler() != null && this.isRootContext()) {
            try {
                this.tracer.getHandler().handle(this.getRootTrace());
            }
            catch (RuntimeException ex) {
                LOG.log(Level.SEVERE, "An error occurred handling a trace.", ex);
            }
        }
    }

    public String toString() {
        return "TraceContext: " + this.getName();
    }
}

