/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.helpers.MessageFormatter;

public final class Trace {
    private final boolean isGap;
    private String label;
    private Object[] labelFormatArgs;
    private final Instant startTime;
    private Instant endTime;
    private final Trace parentTrace;
    private List<Trace> subTraces;
    private List<Trace> subTracesReadOnly;
    private final boolean isContextRoot;
    private Throwable exitThrowable;
    private boolean warn;
    private Map<String, Object> dataMap;

    private Trace(Trace parentTrace, boolean isContextRoot, boolean isGap, Instant startTime, Instant endTime, String label, Object[] labelFormatArgs) {
        this.isGap = isGap;
        this.label = label;
        this.labelFormatArgs = labelFormatArgs;
        this.parentTrace = parentTrace;
        this.isContextRoot = isContextRoot;
        this.startTime = startTime;
        this.endTime = endTime;
        if (parentTrace != null) {
            parentTrace.addSubTrace(this);
        }
    }

    public static Trace newGap(Trace parentTrace, Instant startTime, Instant endTime) {
        return new Trace(parentTrace, false, true, startTime, endTime, "?", null);
    }

    public static Trace newExplicit(Trace parentTrace, Instant startTime, String label, Object[] labelFormatArgs) {
        return new Trace(parentTrace, false, false, startTime, null, label, labelFormatArgs);
    }

    public static Trace newContextRoot(Trace parentTrace, Instant startTime, String label, Object[] labelFormatArgs) {
        return new Trace(parentTrace, true, false, startTime, null, label, labelFormatArgs);
    }

    public String getLabel() {
        if (this.labelFormatArgs != null && this.labelFormatArgs.length > 0) {
            this.label = MessageFormatter.arrayFormat((String)this.label, (Object[])this.labelFormatArgs).getMessage();
            this.labelFormatArgs = null;
        }
        return this.label;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        if (!this.hasEnded()) {
            throw new IllegalStateException("the trace has not yet finished");
        }
        return this.endTime;
    }

    public boolean hasEnded() {
        return this.endTime != null;
    }

    public void end(Instant endTime) {
        this.end(endTime, null);
    }

    public void end(Instant endTime, Throwable exitThrowable) {
        Objects.requireNonNull(endTime, "endTime must not be null");
        if (this.hasEnded()) {
            throw new IllegalStateException("trace has already ended");
        }
        this.exitThrowable = exitThrowable;
        Trace t = this;
        while (!t.hasEnded()) {
            t.endTime = endTime;
            if (this.subTraces == null || this.subTraces.isEmpty()) break;
            t = this.subTraces.get(this.subTraces.size() - 1);
        }
    }

    public Duration getDuration() {
        return Duration.ofMillis(this.getEndTime().toEpochMilli() - this.getStartTime().toEpochMilli());
    }

    public Trace getParentTrace() {
        return this.parentTrace;
    }

    public boolean isContextRoot() {
        return this.isContextRoot;
    }

    public boolean isGap() {
        return this.isGap;
    }

    public List<Trace> getSubTraces() {
        if (this.subTraces == null) {
            return Collections.emptyList();
        }
        if (this.subTracesReadOnly == null) {
            this.subTracesReadOnly = Collections.unmodifiableList(this.subTraces);
        }
        return this.subTracesReadOnly;
    }

    public Trace getLastSubTrace() {
        List<Trace> st = this.getSubTraces();
        if (st.isEmpty()) {
            return null;
        }
        return st.get(st.size() - 1);
    }

    public Trace getActiveTrace(boolean includeRoot) {
        Trace activeTrace = null;
        Trace t = this;
        while (!(t.hasEnded() || t != this && t.isContextRoot())) {
            if (includeRoot || t != this) {
                activeTrace = t;
            }
            if (t.subTraces == null || t.subTraces.isEmpty()) break;
            t = t.subTraces.get(t.subTraces.size() - 1);
        }
        return activeTrace;
    }

    private void addSubTrace(Trace trace) {
        if (this.subTraces == null) {
            this.subTraces = new ArrayList<Trace>();
        }
        this.subTraces.add(trace);
    }

    public Optional<Throwable> getExitThrowable() {
        return Optional.ofNullable(this.exitThrowable);
    }

    public boolean isWarn() {
        return this.warn;
    }

    public void setWarn(boolean warn) {
        this.warn = warn;
    }

    public <T> T getData(Class<T> key) {
        return key.cast(this.dataMap.get(key.getClass().getName()));
    }

    public <T> void setData(Class<T> key, T data) {
        this.dataMap.put(key.getClass().getName(), data);
    }

    public Object getData(String key) {
        return this.dataMap.get(key);
    }

    public <T> T getData(String key, Class<T> type) {
        return type.cast(this.dataMap.get(key));
    }

    public void setData(String key, Object data) {
        this.dataMap.put(key, data);
    }

    public Map<String, Object> getData() {
        return this.dataMap;
    }

    public void setData(Map<String, Object> data) {
        this.dataMap.clear();
        this.dataMap.putAll(data);
    }

    public String toString() {
        return "Trace(" + this.getParentTrace() + " -> " + this.getLabel() + ")";
    }
}

