/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer;

import de.codecamp.tracer.ActiveTrace;
import de.codecamp.tracer.TraceContext;
import de.codecamp.tracer.impl.NoOpTraceContext;
import de.codecamp.tracer.impl.ParamListArg;
import de.codecamp.tracer.impl.TraceContextImpl;

public interface Tracer {
    default public TraceContext openContext(String fullContextName, String contextLabel) {
        return this.openContext(fullContextName, contextLabel, (Object[])null);
    }

    public TraceContext openContext(String var1, String var2, Object ... var3);

    default public TraceContext openContext(Class<?> tracedClass, String methodName, Object ... paramValues) {
        String fullContextName = String.format("%s#%s", tracedClass.getCanonicalName(), methodName);
        return this.openContext(fullContextName, "{}#{}({})", tracedClass.getSimpleName(), methodName, new ParamListArg(paramValues));
    }

    public static boolean hasContext() {
        return TraceContextImpl.CURRENT_CONTEXT.get() != null;
    }

    public static TraceContext context() {
        TraceContext traceContext = TraceContextImpl.CURRENT_CONTEXT.get();
        if (traceContext == null) {
            return NoOpTraceContext.INSTANCE;
        }
        return traceContext;
    }

    public static ActiveTrace activeTrace() {
        return Tracer.context().getActiveTrace();
    }
}

