/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer.formatters;

import de.codecamp.tracer.Trace;
import de.codecamp.tracer.TraceFormatter;
import java.text.DecimalFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class DefaultTraceFormatter
implements TraceFormatter {
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter TIME_FORMAT_WITH_MILLIS = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final Map<TreeStyle, String[]> TREE_STYLE_SYMBOLS = new HashMap<TreeStyle, String[]>();
    private int lineWidth = 100;
    private boolean prefixNewLine = false;
    private TreeStyle treeStyle = TreeStyle.SPACES;

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setPrefixNewLine(boolean prefixNewLine) {
        this.prefixNewLine = prefixNewLine;
    }

    public void setTreeStyle(TreeStyle treeStyle) {
        this.treeStyle = treeStyle;
    }

    @Override
    public String format(Trace trace) {
        boolean durationInMillis = trace.getDuration().toMillis() <= 9999L;
        ArrayList<Triple<String, String, Integer>> lines = new ArrayList<Triple<String, String, Integer>>();
        this.formatTrace(lines, trace, true, 0, "", durationInMillis);
        int labelColumnWidth = 0;
        int durationColumnWidth = 0;
        for (Triple triple : lines) {
            labelColumnWidth = Math.max(((String)triple.getLeft()).length(), labelColumnWidth);
            if (triple.getMiddle() == null) continue;
            durationColumnWidth = Math.max(((String)triple.getMiddle()).length(), durationColumnWidth);
        }
        int staticAdditionsWidth = 5;
        int n = labelColumnWidth + durationColumnWidth + staticAdditionsWidth;
        int actualLineWidth = Math.max(n, this.lineWidth);
        StringBuilder sb = new StringBuilder();
        if (this.prefixNewLine) {
            sb.append("\n");
        }
        String dateString = DATETIME_FORMAT.format(trace.getStartTime().atZone(ZoneId.systemDefault()));
        sb.append(StringUtils.rightPad((String)(dateString + " "), (int)actualLineWidth, (String)"="));
        sb.append("\n");
        int labelTargetWidth = actualLineWidth - durationColumnWidth - staticAdditionsWidth;
        for (Triple triple : lines) {
            String label = (String)triple.getLeft();
            String duration = (String)triple.getMiddle();
            int labelPadWidth = labelTargetWidth - label.length();
            if (duration != null) {
                sb.append(label);
                sb.append(" .");
                sb.append(StringUtils.repeat((String)".", (int)labelPadWidth));
                sb.append(" [");
                sb.append(StringUtils.leftPad((String)duration, (int)durationColumnWidth));
                sb.append("]");
            } else {
                sb.append(StringUtils.leftPad((String)label, (int)actualLineWidth));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void formatTrace(List<Triple<String, String, Integer>> lines, Trace trace, boolean isLastChild, int depth, String labelPrefix, boolean durationInMillis) {
        String duration;
        StringBuilder labelBuilder = new StringBuilder();
        labelBuilder.append(labelPrefix);
        if (depth > 0) {
            String[] treeStyles = TREE_STYLE_SYMBOLS.get((Object)this.treeStyle);
            labelBuilder.append(isLastChild ? treeStyles[1] : treeStyles[0]);
        }
        labelBuilder.append(trace.getLabel());
        if (trace.isContextRoot()) {
            labelBuilder.append(" *");
        }
        if (durationInMillis) {
            duration = Long.toString(trace.getDuration().toMillis()) + " ms";
        } else {
            DecimalFormat df = new DecimalFormat();
            df.setMinimumFractionDigits(3);
            df.setMaximumFractionDigits(3);
            String durationString = df.format((float)trace.getDuration().toMillis() / 1000.0f);
            duration = durationString + " s";
        }
        if (trace.isWarn()) {
            duration = "! " + duration;
        }
        duration = duration + " @ " + (durationInMillis ? TIME_FORMAT_WITH_MILLIS : TIME_FORMAT).format(trace.getStartTime().atZone(ZoneId.systemDefault()));
        lines.add((Triple<String, String, Integer>)Triple.of((Object)labelBuilder.toString(), (Object)duration, (Object)depth));
        trace.getExitThrowable().ifPresent(t -> {
            String className = ClassUtils.getAbbreviatedName(t.getClass(), (int)Math.max(this.lineWidth - 1, 1));
            lines.add(Triple.of((Object)("!" + className), null, (Object)depth));
        });
        List<Trace> subTraces = trace.getSubTraces();
        for (int i = 0; i < subTraces.size(); ++i) {
            Object childLabelPrefix;
            Trace subTrace = subTraces.get(i);
            if (depth > 0) {
                String[] symbols = TREE_STYLE_SYMBOLS.get((Object)this.treeStyle);
                childLabelPrefix = labelPrefix + (isLastChild ? symbols[3] : symbols[2]);
            } else {
                childLabelPrefix = "";
            }
            this.formatTrace(lines, subTrace, i == subTraces.size() - 1, depth + 1, (String)childLabelPrefix, durationInMillis);
        }
    }

    static {
        TREE_STYLE_SYMBOLS.put(TreeStyle.SPACES, new String[]{"  ", "  ", "  ", "  "});
        TREE_STYLE_SYMBOLS.put(TreeStyle.ARROWS, new String[]{"> ", "> ", "> ", "> "});
        TREE_STYLE_SYMBOLS.put(TreeStyle.DOTS, new String[]{"\u2022 ", "\u2022 ", "\u2022 ", "\u2022 "});
        TREE_STYLE_SYMBOLS.put(TreeStyle.LINES, new String[]{"\u251c ", "\u2514 ", "\u2502 ", "  "});
    }

    public static enum TreeStyle {
        SPACES,
        LINES,
        ARROWS,
        DOTS;

    }
}

