/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer.handlers;

import de.codecamp.tracer.AbstractTraceHandler;
import de.codecamp.tracer.Trace;
import de.codecamp.tracer.TraceFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Slf4jLoggingTraceHandler
extends AbstractTraceHandler {
    public static final String MARKER_NAME = "tracer";
    private static final Marker MARKER = MarkerFactory.getMarker((String)"tracer");
    private final Logger logger;
    private TraceFormatter formatter;

    public Slf4jLoggingTraceHandler() {
        this("de.codecamp.tracer");
    }

    public Slf4jLoggingTraceHandler(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public void setFormatter(TraceFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public void handle(Trace trace) {
        if (this.containsWarnings(trace)) {
            this.logger.warn(MARKER, this.formatter.format(trace));
        } else {
            this.logger.trace(MARKER, this.formatter.format(trace));
        }
    }
}

