/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer.spring.aop;

import de.codecamp.tracer.TraceContext;
import de.codecamp.tracer.Tracer;
import de.codecamp.tracer.annotations.Masked;
import de.codecamp.tracer.annotations.Traced;
import de.codecamp.tracer.impl.ParamListArg;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

@Aspect
public class TracerAspect {
    private Tracer tracer;

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    @Pointcut(value="@within(de.codecamp.tracer.annotations.Traced) || (@annotation(de.codecamp.tracer.annotations.Traced) && execution(public * *(..)))")
    private void tracedMethods() {
    }

    @Around(value="tracedMethods()")
    public Object profileAdvice(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature methodSig = (MethodSignature)pjp.getSignature();
        Traced annotation = TracerAspect.findAnnotation(methodSig.getMethod(), pjp.getTarget().getClass());
        Class<?> tracedClass = pjp.getTarget().getClass();
        if (annotation != null && !annotation.ignore()) {
            Object object;
            block10: {
                String methodName = methodSig.getName();
                Object[] paramValues = (Object[])pjp.getArgs().clone();
                Annotation[][] allAnnotations = methodSig.getMethod().getParameterAnnotations();
                block6: for (int i = 0; i < allAnnotations.length; ++i) {
                    for (Annotation a : allAnnotations[i]) {
                        if (!(a instanceof Masked)) continue;
                        paramValues[i] = ((Masked)a).value();
                        continue block6;
                    }
                }
                String fullContextName = String.format("%s#%s", tracedClass.getCanonicalName(), methodName);
                TraceContext tc = this.tracer.openContext(fullContextName, "{}#{}({})", new Object[]{tracedClass.getSimpleName(), methodName, new ParamListArg(paramValues)});
                try {
                    object = pjp.proceed();
                    if (tc == null) break block10;
                }
                catch (Throwable t) {
                    try {
                        tc.setExitThrowable(t);
                        throw t;
                    }
                    catch (Throwable throwable) {
                        if (tc != null) {
                            try {
                                tc.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                tc.close();
            }
            return object;
        }
        return pjp.proceed();
    }

    static Traced findAnnotation(Method method, Class<?> targetClass) {
        Class userClass = ClassUtils.getUserClass(targetClass);
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)userClass);
        Traced annotation = (Traced)AnnotationUtils.getAnnotation((Method)specificMethod, Traced.class);
        if (annotation == null) {
            annotation = (Traced)AnnotationUtils.getAnnotation(specificMethod.getDeclaringClass(), Traced.class);
        }
        if (annotation == null && specificMethod != method && (annotation = (Traced)AnnotationUtils.getAnnotation((Method)method, Traced.class)) == null) {
            annotation = (Traced)AnnotationUtils.getAnnotation(method.getDeclaringClass(), Traced.class);
        }
        return annotation;
    }
}

