/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.tracer.spring.autoconfigure;

import de.codecamp.tracer.formatters.DefaultTraceFormatter;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="codecamp.tracer")
@Validated
public class TracerPropertiers {
    private boolean enabled = true;
    @NotBlank
    private String loggerName = "de.codecamp.tracer";
    private boolean gapsTraced = false;
    @NotNull
    private Duration gapsThreshold = Duration.ZERO;
    private String[] includes;
    private String[] excludes;
    private String[] warnThresholds;
    @Valid
    @NestedConfigurationProperty
    private final Formatter formatter = new Formatter();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public boolean isGapsTraced() {
        return this.gapsTraced;
    }

    public void setGapsTraced(boolean gapsIncluded) {
        this.gapsTraced = gapsIncluded;
    }

    public Duration getGapsThreshold() {
        return this.gapsThreshold;
    }

    public void setGapsThreshold(Duration gapsThreshold) {
        this.gapsThreshold = gapsThreshold;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] filters) {
        this.includes = filters;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] filters) {
        this.excludes = filters;
    }

    public String[] getWarnThresholds() {
        return this.warnThresholds;
    }

    public void setWarnThresholds(String[] warnThresholds) {
        this.warnThresholds = warnThresholds;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public static class Formatter {
        @PositiveOrZero
        private int lineWidth = 0;
        private boolean prefixNewLine = true;
        @NotNull
        private DefaultTraceFormatter.TreeStyle treeStyle = DefaultTraceFormatter.TreeStyle.SPACES;

        public int getLineWidth() {
            return this.lineWidth;
        }

        public void setLineWidth(int lineWidth) {
            this.lineWidth = lineWidth;
        }

        public boolean getPrefixNewLine() {
            return this.prefixNewLine;
        }

        public void setPrefixNewLine(boolean prefixNewLine) {
            this.prefixNewLine = prefixNewLine;
        }

        public DefaultTraceFormatter.TreeStyle getTreeStyle() {
            return this.treeStyle;
        }

        public void setTreeStyle(DefaultTraceFormatter.TreeStyle treeStyle) {
            this.treeStyle = treeStyle;
        }
    }
}

