/*
 * Decompiled with CFR 0.152.
 */
package de.creativecouple.validation.isbn;

import de.creativecouple.validation.isbn.ISBN;
import de.creativecouple.validation.isbn.ISBNValidator;
import java.util.function.BiFunction;

public final class ISBNValidatorBuilder {
    private final int isbnLength;
    private static final BiFunction<String, ISBN, Boolean> ANY_ISBN = (string, isbn) -> true;
    private static final BiFunction<String, ISBN, Boolean> ANY_ISBN_HYPHENATED = (string, isbn) -> {
        if (string.length() == 17) {
            return isbn.toString().equals(string);
        }
        return string.length() == 13 && isbn.getPrefix().equals("978") && string.startsWith(isbn.getGroup() + "-" + isbn.getPublisher() + "-" + isbn.getTitle() + "-");
    };
    private static final BiFunction<String, ISBN, Boolean> ANY_ISBN_COMPACT = (string, isbn) -> {
        if (string.length() == 13) {
            return isbn.toCompactString().equals(string);
        }
        return string.length() == 10 && isbn.getPrefix().equals("978") && string.startsWith(isbn.getGroup() + isbn.getPublisher() + isbn.getTitle());
    };
    private static final BiFunction<String, ISBN, Boolean> ANY_ISBN_HYPHENATED_OR_COMPACT = (string, isbn) -> ANY_ISBN_HYPHENATED.apply((String)string, (ISBN)isbn) != false || ANY_ISBN_COMPACT.apply((String)string, (ISBN)isbn) != false;
    private static final BiFunction<String, ISBN, Boolean> ISBN13 = (string, isbn) -> ISBNValidatorBuilder.countDigits(string) == 13;
    private static final BiFunction<String, ISBN, Boolean> ISBN13_HYPHENATED = (string, isbn) -> isbn.toString().equals(string);
    private static final BiFunction<String, ISBN, Boolean> ISBN13_COMPACT = (string, isbn) -> isbn.toCompactString().equals(string);
    private static final BiFunction<String, ISBN, Boolean> ISBN13_HYPHENATED_OR_COMPACT = (string, isbn) -> ISBN13_HYPHENATED.apply((String)string, (ISBN)isbn) != false || ISBN13_COMPACT.apply((String)string, (ISBN)isbn) != false;
    private static final BiFunction<String, ISBN, Boolean> ISBN10 = (string, isbn) -> ISBNValidatorBuilder.countDigits(string) == 10;
    private static final BiFunction<String, ISBN, Boolean> ISBN10_HYPHENATED = (string, isbn) -> string.length() == 13 && isbn.getPrefix().equals("978") && string.startsWith(isbn.getGroup() + "-" + isbn.getPublisher() + "-" + isbn.getTitle() + "-");
    private static final BiFunction<String, ISBN, Boolean> ISBN10_COMPACT = (string, isbn) -> string.length() == 10;
    private static final BiFunction<String, ISBN, Boolean> ISBN10_HYPHENATED_OR_COMPACT = (string, isbn) -> ISBN10_HYPHENATED.apply((String)string, (ISBN)isbn) != false || ISBN10_COMPACT.apply((String)string, (ISBN)isbn) != false;

    ISBNValidatorBuilder(Integer isbnLength) {
        this.isbnLength = isbnLength;
    }

    public ISBNValidator hyphenation(HyphenationOption option) {
        switch (option) {
            case CORRECT: {
                switch (this.isbnLength) {
                    case 13: {
                        return new ISBNValidator(ISBN13_HYPHENATED);
                    }
                    case 10: {
                        return new ISBNValidator(ISBN10_HYPHENATED);
                    }
                }
                return new ISBNValidator(ANY_ISBN_HYPHENATED);
            }
            case NONE: {
                switch (this.isbnLength) {
                    case 13: {
                        return new ISBNValidator(ISBN13_COMPACT);
                    }
                    case 10: {
                        return new ISBNValidator(ISBN10_COMPACT);
                    }
                }
                return new ISBNValidator(ANY_ISBN_COMPACT);
            }
            case CORRECT_OR_NONE: {
                switch (this.isbnLength) {
                    case 13: {
                        return new ISBNValidator(ISBN13_HYPHENATED_OR_COMPACT);
                    }
                    case 10: {
                        return new ISBNValidator(ISBN10_HYPHENATED_OR_COMPACT);
                    }
                }
                return new ISBNValidator(ANY_ISBN_HYPHENATED_OR_COMPACT);
            }
        }
        switch (this.isbnLength) {
            case 13: {
                return new ISBNValidator(ISBN13);
            }
            case 10: {
                return new ISBNValidator(ISBN10);
            }
        }
        return new ISBNValidator(ANY_ISBN);
    }

    private static int countDigits(CharSequence input) {
        int result = 0;
        for (int i = input.length() - 1; i >= 0; --i) {
            char ch = input.charAt(i);
            if ((ch < '0' || ch > '9') && ch != 'x' && ch != 'X') continue;
            ++result;
        }
        return result;
    }

    public static enum HyphenationOption {
        ANY,
        CORRECT,
        NONE,
        CORRECT_OR_NONE;

    }
}

