/*
 * Decompiled with CFR 0.152.
 */
package de.creativecouple.validation.isbn;

import de.creativecouple.validation.isbn.ISBNRanges;
import de.creativecouple.validation.isbn.Parser;
import java.io.Serializable;
import java.net.URI;

public final class ISBN
implements Serializable {
    private final String prefix;
    private final String group;
    private final String publisher;
    private final String title;
    private final char checkdigit;
    private final String isbn13String;

    ISBN(String prefix, String group, String publisher, String title, char checkdigit) {
        this.prefix = prefix;
        this.group = group;
        this.publisher = publisher;
        this.title = title;
        this.checkdigit = checkdigit;
        this.isbn13String = prefix + '-' + group + '-' + publisher + '-' + title + '-' + checkdigit;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getAgencyName() {
        return ISBNRanges.AGENCIES.get(this.prefix);
    }

    public String getGroup() {
        return this.group;
    }

    public String getGroupPrefix() {
        return this.prefix + '-' + this.group;
    }

    public String getGroupName() {
        return ISBNRanges.AGENCIES.get(this.getGroupPrefix());
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getPublisherPrefix() {
        return this.prefix + '-' + this.group + '-' + this.publisher;
    }

    public String getTitle() {
        return this.title;
    }

    public char getCheckdigit() {
        return this.checkdigit;
    }

    public String toString() {
        return this.isbn13String;
    }

    public String toCompactString() {
        return this.prefix + this.group + this.publisher + this.title + this.checkdigit;
    }

    public URI toURI() {
        return URI.create("urn:isbn:" + this.toCompactString());
    }

    public boolean equals(Object obj) {
        return obj instanceof ISBN && ((ISBN)obj).isbn13String.equals(this.isbn13String);
    }

    public int hashCode() {
        return this.isbn13String.hashCode();
    }

    public static ISBN valueOf(String isbn) throws IllegalArgumentException {
        ISBN parsed = Parser.parse(isbn);
        if (parsed == null) {
            throw new NumberFormatException("ISBN invalid: '" + isbn + "'");
        }
        return parsed;
    }
}

