/*
 * Decompiled with CFR 0.152.
 */
package de.creativecouple.validation.isbn;

import de.creativecouple.validation.isbn.ISBN;
import de.creativecouple.validation.isbn.ISBNValidatorBuilder;
import de.creativecouple.validation.isbn.Parser;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public final class ISBNValidator
implements Predicate<String> {
    private final BiFunction<String, ISBN, Boolean> inputCheck;

    ISBNValidator(BiFunction<String, ISBN, Boolean> inputCheck) {
        this.inputCheck = inputCheck;
    }

    @Override
    public boolean test(String isbnString) {
        ISBN isbn = Parser.parse(isbnString);
        return isbn != null && this.inputCheck.apply(isbnString, isbn) != false;
    }

    public boolean equals(Object obj) {
        return obj instanceof ISBNValidator && this.inputCheck.equals(((ISBNValidator)obj).inputCheck);
    }

    public int hashCode() {
        return this.inputCheck.hashCode();
    }

    public ISBN parse(String input) {
        ISBN isbn = Parser.parse(input);
        if (isbn == null || !this.inputCheck.apply(input, isbn).booleanValue()) {
            throw new IllegalArgumentException("invalid input: '" + input + "'");
        }
        return isbn;
    }

    public static ISBNValidatorBuilder anyIsbn() {
        return new ISBNValidatorBuilder(0);
    }

    public static ISBNValidatorBuilder isbn10() {
        return new ISBNValidatorBuilder(10);
    }

    public static ISBNValidatorBuilder isbn13() {
        return new ISBNValidatorBuilder(13);
    }
}

