/*
 * Decompiled with CFR 0.152.
 */
package de.creativecouple.validation.isbn;

import de.creativecouple.validation.isbn.ISBN;
import de.creativecouple.validation.isbn.ISBNRanges;
import de.creativecouple.validation.isbn.Range;

final class Parser {
    private static final long[] decimals = new long[]{1000000000000L, 100000000000L, 10000000000L, 1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};

    Parser() {
    }

    static ISBN parse(String isbnString) {
        long longValue;
        if (isbnString == null) {
            return null;
        }
        char[] isbn = Parser.normalizeDashes(isbnString);
        if (isbn == null) {
            return null;
        }
        if (isbn[10] < '0') {
            longValue = Parser.validateChecksum10(isbn);
            if (longValue <= 0L) {
                return null;
            }
            Parser.convertToIsbn13(isbn, longValue);
        } else {
            longValue = Parser.validateChecksum13(isbn);
            if (longValue <= 0L) {
                return null;
            }
        }
        Range prefixRange = Parser.findRange(longValue, ISBNRanges.ROOT);
        if (prefixRange == null || prefixRange.rules == null) {
            return null;
        }
        int prefixEnd = prefixRange.width;
        Range[] groupRule = prefixRange.rules[(int)((longValue - prefixRange.lower) / decimals[prefixEnd])];
        if (groupRule == null) {
            return null;
        }
        Range groupRange = Parser.findRange(longValue, groupRule);
        if (groupRange == null || groupRange.rules == null) {
            return null;
        }
        int groupEnd = prefixEnd + groupRange.width;
        Range[] publisherRule = groupRange.rules[(int)((longValue - groupRange.lower) / decimals[groupEnd])];
        if (publisherRule == null) {
            return null;
        }
        Range publisherRange = Parser.findRange(longValue, publisherRule);
        if (publisherRange == null) {
            return null;
        }
        int publisherEnd = groupEnd + publisherRange.width;
        return new ISBN(new String(isbn, 0, prefixRange.width), new String(isbn, prefixEnd, groupRange.width), new String(isbn, groupEnd, publisherRange.width), new String(isbn, publisherEnd, 12 - publisherEnd), isbn[12]);
    }

    private static void convertToIsbn13(char[] isbn, long longValue) {
        isbn[12] = (char)(Parser.calculateCheckDigit(longValue) + 48);
        for (int i = 8; i >= 0; --i) {
            isbn[i + 3] = isbn[i];
        }
        isbn[2] = 56;
        isbn[1] = 55;
        isbn[0] = 57;
    }

    private static char[] normalizeDashes(CharSequence string) {
        char[] chars = new char[13];
        int charsPos = 0;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '-' || ch == '_' || ch == '\u2013' || ch == '\u2014' || ch == '\u2212') continue;
            if (ch != 'x' && ch != 'X' && (ch < '0' || ch > '9')) {
                return null;
            }
            if (charsPos >= 13) {
                return null;
            }
            chars[charsPos++] = ch;
        }
        return (char[])(charsPos == 10 || charsPos == 13 ? chars : null);
    }

    private static Range findRange(long longValue, Range[] rule) {
        for (Range range : rule) {
            if (longValue > range.upper) continue;
            return longValue < range.lower ? null : range;
        }
        return null;
    }

    private static long validateChecksum10(char[] isbn10) {
        int sum = 0;
        long value = 978L;
        int i = 0;
        int weight = 10;
        while (i < 10) {
            char chr = isbn10[i];
            int digit = chr - 48;
            if (digit < 0 || digit > 9) {
                if (i == 9 && (digit == 40 || digit == 72)) {
                    digit = 10;
                } else {
                    return -1L;
                }
            }
            if (i < 9) {
                value = value * 10L + (long)digit;
            }
            sum += weight * digit;
            ++i;
            --weight;
        }
        return sum % 11 == 0 ? value : -1L;
    }

    private static long validateChecksum13(char[] isbn13) {
        int sum = 0;
        long value = 0L;
        int i = 0;
        int weight = 1;
        while (i < 13) {
            char chr = isbn13[i];
            int digit = chr - 48;
            if (digit < 0 || digit > 9) {
                return -1L;
            }
            sum += weight * digit;
            if (i < 12) {
                value = value * 10L + (long)digit;
            }
            ++i;
            weight ^= 2;
        }
        return sum % 10 == 0 ? value : -1L;
    }

    static int calculateCheckDigit(long value) {
        int sum = 0;
        int i = 0;
        int weight = 3;
        while (i < 12) {
            sum += weight * (int)(value % 10L);
            ++i;
            weight ^= 2;
            value /= 10L;
        }
        return (10 - sum % 10) % 10;
    }
}

