/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.yaml.joda;

import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class JodaTimeConstructor
extends Constructor {
    public JodaTimeConstructor() {
        this.yamlConstructors.put(Tag.TIMESTAMP, new ConstructJodaTimestamp());
        this.yamlConstructors.put(new Tag("!localTimestamp"), new ConstructJodaLocalTimestamp());
    }

    private class ConstructJodaLocalTimestamp
    extends SafeConstructor.ConstructYamlTimestamp {
        private ConstructJodaLocalTimestamp() {
        }

        public Object construct(Node node) {
            ScalarNode scalarNode = (ScalarNode)node;
            return LocalDateTime.parse((String)scalarNode.getValue());
        }
    }

    private class ConstructJodaTimestamp
    extends SafeConstructor.ConstructYamlTimestamp {
        private ConstructJodaTimestamp() {
        }

        public Object construct(Node node) {
            return new DateTime(super.construct(node));
        }
    }
}

