/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.frontend.website.service;

import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiWebsitesClient;
import de.digitalcollections.cudami.client.identifiable.web.CudamiWebpagesClient;
import de.digitalcollections.cudami.frontend.website.config.CudamiConfig;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ContentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentService.class);
    private final CudamiConfig cudamiConfig;
    private final CudamiWebpagesClient cudamiWebpagesClient;
    private final CudamiWebsitesClient cudamiWebsitesClient;

    public ContentService(CudamiConfig cudamiConfig, CudamiClient cudamiClient) {
        this.cudamiConfig = cudamiConfig;
        this.cudamiWebpagesClient = cudamiClient.forWebpages();
        this.cudamiWebsitesClient = cudamiClient.forWebsites();
    }

    public List<Webpage> getContentPages() {
        try {
            List allContentWebpages;
            Website website = this.getWebsite();
            if (this.cudamiConfig.getWebpage("content") == null) {
                PageRequest pageRequest = PageRequest.builder().pageSize(100).build();
                PageResponse rootPagesResponse = this.cudamiWebsitesClient.findRootWebpages(website.getUuid(), pageRequest);
                allContentWebpages = rootPagesResponse.getContent();
            } else {
                Pair webpagePair = this.getWebpage(this.cudamiConfig.getWebpage("content"));
                Webpage webpage = (Webpage)webpagePair.getLeft();
                allContentWebpages = webpage.getChildren();
            }
            List<Webpage> activeContentWebpages = allContentWebpages.stream().filter(arg_0 -> this.isActive(arg_0)).collect(Collectors.toList());
            for (Webpage activeContentWebpage : activeContentWebpages) {
                List activeChildrenTree = this.cudamiWebpagesClient.getActiveChildrenTree(activeContentWebpage.getUuid());
                activeContentWebpage.setChildren(activeChildrenTree);
            }
            return activeContentWebpages;
        }
        catch (TechnicalException ex) {
            LOGGER.warn("Could not fetch content webpages due to exc={}", (Throwable)ex);
            return null;
        }
    }

    public List<Webpage> getFooterPages() {
        Pair webpagePair;
        if (this.cudamiConfig.getWebpage("footer") != null && (webpagePair = this.getWebpage(this.cudamiConfig.getWebpage("footer"))) != null) {
            Webpage webpage = (Webpage)webpagePair.getLeft();
            return webpage.getChildren();
        }
        return null;
    }

    private Locale getLocale(Webpage webpage) {
        if (webpage == null) {
            return null;
        }
        return (Locale)webpage.getLabel().getLocales().iterator().next();
    }

    public Webpage getStartPage() {
        if (this.cudamiConfig.getWebpage("content") != null) {
            Pair webpagePair = this.getWebpage(this.cudamiConfig.getWebpage("content"));
            Webpage webpage = (Webpage)webpagePair.getLeft();
            return webpage;
        }
        return null;
    }

    public Pair<Webpage, Locale> getWebpage(UUID uuid) {
        Webpage webpage;
        try {
            Locale locale = Locale.forLanguageTag(LocaleContextHolder.getLocale().getLanguage());
            webpage = this.cudamiWebpagesClient.getActiveByUuid(uuid, locale);
        }
        catch (TechnicalException ex) {
            LOGGER.warn("Could not fetch webpage with uuid={} due to exc={}", (Object)uuid.toString(), (Object)ex);
            webpage = null;
        }
        Locale webpageLocale = this.getLocale(webpage);
        return Pair.of((Object)webpage, (Object)webpageLocale);
    }

    public Website getWebsite() {
        UUID websiteUuid = this.cudamiConfig.getWebsite();
        try {
            return (Website)this.cudamiWebsitesClient.getByUuid(websiteUuid);
        }
        catch (TechnicalException ex) {
            LOGGER.error("Website with UUID {} can not be loaded due to exc={}", (Object)websiteUuid, (Object)ex);
            return null;
        }
    }

    public boolean isActive(Webpage f) {
        LocalDate now = LocalDate.now();
        return f.getPublicationStart() != null && f.getPublicationStart().compareTo(now) <= 0 && (f.getPublicationEnd() == null || f.getPublicationEnd().compareTo(now) > 0);
    }
}

