/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.frontend.website.config;

import de.digitalcollections.cudami.frontend.website.config.CudamiConfig;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="cudami")
@Validated
public class CudamiConfig {
    private final Server server;
    private final Map<String, UUID> webpages;
    @NotNull
    private final UUID website;

    public CudamiConfig(Server server, Map<String, UUID> webpages, UUID website) {
        this.server = server;
        this.webpages = webpages != null ? Map.copyOf(webpages) : null;
        this.website = website;
    }

    public Server getServer() {
        return this.server;
    }

    public UUID getWebpage(String name) {
        if (this.webpages == null) {
            return null;
        }
        return (UUID)this.webpages.get(name);
    }

    public Map<String, UUID> getWebpages() {
        return this.webpages != null ? Map.copyOf(this.webpages) : null;
    }

    public UUID getWebsite() {
        return this.website;
    }
}

