/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.frontend.website.controller;

import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.alias.CudamiUrlAliasClient;
import de.digitalcollections.cudami.frontend.website.config.CudamiConfig;
import de.digitalcollections.cudami.frontend.website.controller.UrlAliasController;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class UrlAliasController {
    private final CudamiUrlAliasClient cudamiUrlAliasClient;
    private final UUID websiteUuid;

    public UrlAliasController(CudamiClient cudamiClient, CudamiConfig cudamiConfig) {
        this.cudamiUrlAliasClient = cudamiClient.forUrlAliases();
        this.websiteUuid = cudamiConfig.getWebsite();
    }

    @GetMapping(value={"/{slug:[a-zA-Z0-9-]+}"})
    public String fallback(HttpServletRequest request, @PathVariable String slug) throws ResourceNotFoundException, TechnicalException {
        LocalizedUrlAliases primaryUrlAliasesOfTargetIdentifiable = this.cudamiUrlAliasClient.getPrimaryLinks(this.websiteUuid, slug);
        if (primaryUrlAliasesOfTargetIdentifiable.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        UrlAlias firstMatchingPrimaryUrlAlias = this.getFirstMatchingPrimaryUrlAlias(primaryUrlAliasesOfTargetIdentifiable);
        if (slug.equals(firstMatchingPrimaryUrlAlias.getSlug())) {
            request.setAttribute("request_uri", (Object)request.getRequestURI());
            UUID targetUUID = firstMatchingPrimaryUrlAlias.getTargetUuid();
            IdentifiableObjectType targetIdentifiableObjectType = firstMatchingPrimaryUrlAlias.getTargetIdentifiableObjectType();
            switch (1.$SwitchMap$de$digitalcollections$model$identifiable$IdentifiableObjectType[targetIdentifiableObjectType.ordinal()]) {
                case 1: {
                    return "forward:/p/" + targetUUID;
                }
            }
            throw new ResourceNotFoundException(String.format("Handling for identifiable %s of type %s not found.", targetUUID, targetIdentifiableObjectType));
        }
        return "redirect:/" + firstMatchingPrimaryUrlAlias.getSlug();
    }

    private UrlAlias getFirstMatchingPrimaryUrlAlias(LocalizedUrlAliases primaryUrlAliasesOfTargetIdentifiable) {
        Locale locale = this.getLocaleFromPrimaryUrlAliases(primaryUrlAliasesOfTargetIdentifiable);
        UrlAlias firstMatchingPrimaryUrlAlias = (UrlAlias)((List)primaryUrlAliasesOfTargetIdentifiable.get((Object)locale)).get(0);
        return firstMatchingPrimaryUrlAlias;
    }

    protected Locale getLocaleFromPrimaryUrlAliases(LocalizedUrlAliases localizedUrlAliases) {
        if (localizedUrlAliases.getTargetLanguages().size() == 1) {
            return (Locale)localizedUrlAliases.getTargetLanguages().get(0);
        }
        Locale locale = LocaleContextHolder.getLocale();
        if (!localizedUrlAliases.hasTargetLanguage(locale)) {
            locale = (Locale)localizedUrlAliases.getTargetLanguages().get(0);
        }
        return locale;
    }
}

