/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.api.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.commons.feign.codec.EndpointErrorDecoder;
import feign.Feign;
import feign.RequestLine;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public interface LocaleRepository {
    @RequestLine(value="GET /latest/languages")
    public List<String> findAllLanguages();

    @RequestLine(value="GET /latest/languages/default")
    public Locale getDefaultLanguage();

    @RequestLine(value="GET /latest/locales")
    public List<String> findAllLocales();

    @RequestLine(value="GET /latest/locales/default")
    public String getDefaultLocale();

    @Configuration
    public static class Config {
        @Value(value="${cudami.server.address}")
        private String cudamiServerAddress;
        @Autowired
        ObjectMapper objectMapper;

        @Bean
        public LocaleRepository localeRepository() {
            LocaleRepository endpoint = (LocaleRepository)Feign.builder().decoder((Decoder)new JacksonDecoder(this.objectMapper)).encoder((Encoder)new JacksonEncoder(this.objectMapper)).errorDecoder((ErrorDecoder)new EndpointErrorDecoder()).target(LocaleRepository.class, this.cudamiServerAddress);
            return endpoint;
        }
    }
}

