/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.core.model.api.paging.Order;
import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.core.model.api.paging.Sorting;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.WebsiteRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.WebsiteRepositoryEndpoint;
import de.digitalcollections.cudami.model.api.identifiable.parts.MultilanguageDocument;
import de.digitalcollections.cudami.model.api.identifiable.parts.Text;
import de.digitalcollections.cudami.model.api.identifiable.resource.Webpage;
import de.digitalcollections.cudami.model.impl.identifiable.entity.WebsiteImpl;
import de.digitalcollections.cudami.model.impl.identifiable.parts.MultilanguageDocumentImpl;
import de.digitalcollections.cudami.model.impl.identifiable.parts.TextImpl;
import de.digitalcollections.prosemirror.model.api.ContentBlock;
import de.digitalcollections.prosemirror.model.api.Document;
import de.digitalcollections.prosemirror.model.impl.DocumentImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.ParagraphImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebsiteRepositoryImpl
implements WebsiteRepository<WebsiteImpl> {
    @Autowired
    private WebsiteRepositoryEndpoint endpoint;
    @Autowired
    private LocaleRepository localeRepository;

    public long count() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WebsiteImpl create() {
        Locale defaultLocale = this.localeRepository.getDefault();
        WebsiteImpl website = new WebsiteImpl();
        website.setLabel((Text)new TextImpl(defaultLocale, ""));
        website.setDescription(this.createEmptyMLD(defaultLocale));
        return website;
    }

    private MultilanguageDocument createEmptyMLD(Locale defaultLocale) {
        MultilanguageDocumentImpl emptyMLD = new MultilanguageDocumentImpl();
        DocumentImpl document = new DocumentImpl();
        document.addContentBlock((ContentBlock)new ParagraphImpl());
        emptyMLD.addDocument(defaultLocale, (Document)document);
        return emptyMLD;
    }

    public PageResponse<WebsiteImpl> find(PageRequest pageRequest) {
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        Sorting sorting = pageRequest.getSorting();
        Iterator iterator = sorting.iterator();
        String sortField = "";
        String sortDirection = "";
        String nullHandling = "";
        if (iterator.hasNext()) {
            Order order = (Order)iterator.next();
            sortField = order.getProperty() == null ? "" : order.getProperty();
            sortDirection = order.getDirection() == null ? "" : order.getDirection().name();
            nullHandling = order.getNullHandling() == null ? "" : order.getNullHandling().name();
        }
        return this.endpoint.find(pageNumber, pageSize, sortField, sortDirection, nullHandling);
    }

    public WebsiteImpl findOne(UUID uuid) {
        return this.endpoint.findOne(uuid);
    }

    public List<Webpage> getRootNodes(WebsiteImpl website) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WebsiteImpl save(WebsiteImpl website) {
        return this.endpoint.save(website);
    }

    public WebsiteImpl update(WebsiteImpl website) {
        return this.endpoint.update(website.getUuid(), website);
    }
}

