/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.resource;

import de.digitalcollections.core.model.api.paging.Order;
import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.core.model.api.paging.Sorting;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.resource.WebpageRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.resource.WebpageRepositoryEndpoint;
import de.digitalcollections.cudami.model.api.identifiable.parts.MultilanguageDocument;
import de.digitalcollections.cudami.model.api.identifiable.parts.Text;
import de.digitalcollections.cudami.model.impl.identifiable.parts.MultilanguageDocumentImpl;
import de.digitalcollections.cudami.model.impl.identifiable.parts.TextImpl;
import de.digitalcollections.cudami.model.impl.identifiable.resource.WebpageImpl;
import de.digitalcollections.prosemirror.model.api.ContentBlock;
import de.digitalcollections.prosemirror.model.api.Document;
import de.digitalcollections.prosemirror.model.impl.DocumentImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.ParagraphImpl;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl
implements WebpageRepository<WebpageImpl> {
    @Autowired
    private WebpageRepositoryEndpoint endpoint;
    @Autowired
    LocaleRepository localeRepository;

    public long count() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WebpageImpl create() {
        Locale defaultLocale = this.localeRepository.getDefault();
        WebpageImpl webpage = new WebpageImpl();
        webpage.setLabel((Text)new TextImpl(defaultLocale, ""));
        webpage.setDescription(this.createEmptyMLD(defaultLocale));
        webpage.setText(this.createEmptyMLD(defaultLocale));
        return webpage;
    }

    private MultilanguageDocument createEmptyMLD(Locale defaultLocale) {
        MultilanguageDocumentImpl emptyMLD = new MultilanguageDocumentImpl();
        DocumentImpl document = new DocumentImpl();
        document.addContentBlock((ContentBlock)new ParagraphImpl());
        emptyMLD.addDocument(defaultLocale, (Document)document);
        return emptyMLD;
    }

    public PageResponse<WebpageImpl> find(PageRequest pageRequest) {
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        Sorting sorting = pageRequest.getSorting();
        Iterator iterator = sorting.iterator();
        String sortField = "";
        String sortDirection = "";
        String nullHandling = "";
        if (iterator.hasNext()) {
            Order order = (Order)iterator.next();
            sortField = order.getProperty() == null ? "" : order.getProperty();
            sortDirection = order.getDirection() == null ? "" : order.getDirection().name();
            nullHandling = order.getNullHandling() == null ? "" : order.getNullHandling().name();
        }
        return this.endpoint.find(pageNumber, pageSize, sortField, sortDirection, nullHandling);
    }

    public WebpageImpl findOne(UUID uuid) {
        return this.endpoint.findOne(uuid);
    }

    public WebpageImpl save(WebpageImpl webpage) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WebpageImpl save(WebpageImpl webpage, UUID websiteUUID) {
        return this.endpoint.save(webpage, websiteUUID);
    }

    public WebpageImpl update(WebpageImpl webpage) {
        return this.endpoint.update(webpage.getUuid(), webpage);
    }
}

