/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository;

import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.LocaleRepositoryEndpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class LocaleRepositoryImpl
implements LocaleRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocaleRepositoryImpl.class);
    @Autowired
    private LocaleRepositoryEndpoint endpoint;

    public List<Locale> findAll() {
        List<String> localeCodes = this.endpoint.find();
        ArrayList<Locale> result = new ArrayList<Locale>();
        for (String localeCode : localeCodes) {
            try {
                Locale locale = LocaleUtils.toLocale((String)localeCode);
                result.add(locale);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Illegal argument for Locale: '{}'. Ignoring it.", (Object)localeCode);
            }
        }
        return result;
    }

    public Locale getDefault() {
        String defaultLocaleCode = this.endpoint.getDefault();
        return LocaleUtils.toLocale((String)defaultLocaleCode);
    }
}

