/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.ContentTreeRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.ContentTreeRepositoryEndpoint;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.entity.ContentTree;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.ContentTreeImpl;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ContentTreeRepositoryImpl<C extends ContentTree>
extends EntityRepositoryImpl<C>
implements ContentTreeRepository<C> {
    @Autowired
    private ContentTreeRepositoryEndpoint endpoint;

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public C create() {
        return (C)new ContentTreeImpl();
    }

    @Override
    public PageResponse<C> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<ContentTree> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public C findOne(UUID uuid) {
        return (C)this.endpoint.findOne(uuid);
    }

    @Override
    public C save(C identifiable) {
        return (C)this.endpoint.save((ContentTree)identifiable);
    }

    @Override
    public C update(C identifiable) {
        return (C)this.endpoint.update(identifiable.getUuid(), (ContentTree)identifiable);
    }

    public List<ContentNode> getRootNodes(C contentTree) {
        return this.endpoint.getRootNodes(contentTree.getUuid());
    }
}

