/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.WebsiteRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.WebsiteRepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.WebsiteImpl;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebsiteRepositoryImpl<W extends Website>
extends EntityRepositoryImpl<W>
implements WebsiteRepository<W> {
    @Autowired
    private WebsiteRepositoryEndpoint endpoint;

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public W create() {
        return (W)new WebsiteImpl();
    }

    @Override
    public PageResponse<W> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<Website> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public W findOne(UUID uuid) {
        return (W)this.endpoint.findOne(uuid);
    }

    @Override
    public W save(W identifiable) {
        return (W)this.endpoint.save((Website)identifiable);
    }

    @Override
    public W update(W identifiable) {
        return (W)this.endpoint.update(identifiable.getUuid(), (Website)identifiable);
    }

    public List<Webpage> getRootPages(W website) {
        return this.endpoint.getRootPages(website.getUuid());
    }
}

