/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts.WebpageRepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.parts.WebpageImpl;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl<W extends Webpage, I extends Identifiable>
extends IdentifiableRepositoryImpl<W>
implements WebpageRepository<W, I> {
    @Autowired
    LocaleRepository localeRepository;
    @Autowired
    private WebpageRepositoryEndpoint endpoint;

    public void addIdentifiable(UUID webpageUuid, UUID identifiableUuid) {
        this.endpoint.addIdentifiable(webpageUuid, identifiableUuid);
    }

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public W create() {
        return (W)new WebpageImpl();
    }

    @Override
    public PageResponse<W> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<Webpage> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public W findOne(UUID uuid) {
        return (W)this.endpoint.findOne(uuid);
    }

    @Override
    public W save(W identifiable) {
        return (W)this.endpoint.save((Webpage)identifiable);
    }

    @Override
    public W update(W identifiable) {
        return (W)this.endpoint.update(identifiable.getUuid(), (Webpage)identifiable);
    }

    public List<W> getChildren(UUID uuid) {
        return this.endpoint.getChildren(uuid);
    }

    public List<W> getChildren(W webpage) {
        return this.getChildren((W)webpage.getUuid());
    }

    public W saveWithParentWebsite(W webpage, UUID parentWebsiteUUID) {
        return (W)this.endpoint.saveWithParentWebsite((Webpage)webpage, parentWebsiteUUID);
    }

    public W saveWithParentWebpage(W webpage, UUID parentWebpageUUID) {
        return (W)this.endpoint.saveWithParentWebpage((Webpage)webpage, parentWebpageUUID);
    }

    public List<Identifiable> getIdentifiables(W webpage) {
        return this.getIdentifiables(webpage.getUuid());
    }

    private List<Identifiable> getIdentifiables(UUID uuid) {
        return this.endpoint.getIdentifiables(uuid);
    }

    public List<Identifiable> saveIdentifiables(W webpage, List<Identifiable> identifiables) {
        return this.endpoint.saveIdentifiables(webpage.getUuid(), identifiables);
    }
}

