/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.ArticleRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.ArticleRepositoryEndpoint;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Article;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.ArticleImpl;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ArticleRepositoryImpl<A extends Article, I extends Identifiable>
extends EntityRepositoryImpl<A>
implements ArticleRepository<A, I> {
    @Autowired
    private ArticleRepositoryEndpoint endpoint;

    public void addIdentifiable(UUID articleUuid, UUID identifiableUuid) {
        this.endpoint.addIdentifiable(articleUuid, identifiableUuid);
    }

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public A create() {
        return (A)new ArticleImpl();
    }

    @Override
    public PageResponse<A> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<Article> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public A findOne(UUID uuid) {
        return (A)this.endpoint.findOne(uuid);
    }

    @Override
    public A save(A identifiable) {
        return (A)this.endpoint.save((Article)identifiable);
    }

    @Override
    public A update(A identifiable) {
        return (A)this.endpoint.update(identifiable.getUuid(), (Article)identifiable);
    }

    public List<Identifiable> getIdentifiables(A article) {
        return this.getIdentifiables(article.getUuid());
    }

    private List<Identifiable> getIdentifiables(UUID uuid) {
        return this.endpoint.getIdentifiables(uuid);
    }

    public List<Identifiable> saveIdentifiables(A article, List<Identifiable> identifiables) {
        return this.endpoint.saveIdentifiables(article.getUuid(), identifiables);
    }
}

