/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.ContentNodeRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts.ContentNodeRepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.parts.ContentNodeImpl;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ContentNodeRepositoryImpl<C extends ContentNode, I extends Identifiable>
extends IdentifiableRepositoryImpl<C>
implements ContentNodeRepository<C, I> {
    @Autowired
    LocaleRepository localeRepository;
    @Autowired
    private ContentNodeRepositoryEndpoint endpoint;

    public void addIdentifiable(UUID contentNodeUuid, UUID identifiableUuid) {
        this.endpoint.addIdentifiable(contentNodeUuid, identifiableUuid);
    }

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public C create() {
        return (C)new ContentNodeImpl();
    }

    @Override
    public PageResponse<C> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<ContentNode> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public C findOne(UUID uuid) {
        return (C)this.endpoint.findOne(uuid);
    }

    @Override
    public C save(C identifiable) {
        return (C)this.endpoint.save((ContentNode)identifiable);
    }

    @Override
    public C update(C identifiable) {
        return (C)this.endpoint.update(identifiable.getUuid(), (ContentNode)identifiable);
    }

    public List<C> getChildren(UUID uuid) {
        return this.endpoint.getChildren(uuid);
    }

    public List<C> getChildren(C contentNode) {
        return this.getChildren((C)contentNode.getUuid());
    }

    public C saveWithParentContentTree(C contentNode, UUID parentContentTreeUUID) {
        return (C)this.endpoint.saveWithParentContentTree((ContentNode)contentNode, parentContentTreeUUID);
    }

    public C saveWithParentContentNode(C contentNode, UUID parentContentNodeUUID) {
        return (C)this.endpoint.saveWithParentContentNode((ContentNode)contentNode, parentContentNodeUUID);
    }

    public List<Identifiable> getIdentifiables(C contentNode) {
        return this.getIdentifiables(contentNode.getUuid());
    }

    private List<Identifiable> getIdentifiables(UUID uuid) {
        return this.endpoint.getIdentifiables(uuid);
    }

    public List<Identifiable> saveIdentifiables(C contentNode, List<Identifiable> identifiables) {
        return this.endpoint.saveIdentifiables(contentNode.getUuid(), identifiables);
    }
}

