/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.impl.repository.RepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.EntityRelation;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageResponse;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;

public interface EntityRepositoryEndpoint
extends RepositoryEndpoint {
    @RequestLine(value="POST /latest/entities/{uuid}/related/fileresources/{fileResourceUuid}")
    public void addRelatedFileresource(@Param(value="uuid") UUID var1, @Param(value="fileResourceUuid") UUID var2);

    @RequestLine(value="POST /latest/entities/relations/{subjectEntityUuid}/{predicate}/{objectEntityUuid}")
    public void addRelation(@Param(value="subjectEntityUuid") UUID var1, @Param(value="predicate") String var2, @Param(value="objectEntityUuid") UUID var3);

    @RequestLine(value="GET /latest/entities?pageNumber={pageNumber}&pageSize={pageSize}&sortField={sortField}&sortDirection={sortDirection}&nullHandling={nullHandling}")
    public PageResponse<Entity> find(@Param(value="pageNumber") int var1, @Param(value="pageSize") int var2, @Param(value="sortField") String var3, @Param(value="sortDirection") String var4, @Param(value="nullHandling") String var5);

    @RequestLine(value="GET /latest/entities/{uuid}")
    public Entity findOne(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/entities/{uuid}?locale={locale}")
    public Entity findOne(@Param(value="uuid") UUID var1, @Param(value="locale") String var2);

    @RequestLine(value="GET /latest/entities/{uuid}/related/fileresources")
    public LinkedHashSet<FileResource> getRelatedFileResources(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/entities/relations/{subjectEntityUuid}")
    public List<EntityRelation> getRelations(@Param(value="subjectEntityUuid") UUID var1);

    @RequestLine(value="POST /latest/entities")
    @Headers(value={"Content-Type: application/json"})
    public Entity save(Entity var1);

    @RequestLine(value="POST /latest/entities/{uuid}/related/fileresources")
    public LinkedHashSet<FileResource> saveRelatedFileResources(@Param(value="uuid") UUID var1, LinkedHashSet<FileResource> var2);

    @RequestLine(value="POST /latest/entities/relations")
    public List<EntityRelation> saveRelations(List<EntityRelation> var1);

    @RequestLine(value="PUT /latest/entities/{uuid}")
    @Headers(value={"Content-Type: application/json"})
    public Entity update(@Param(value="uuid") UUID var1, Entity var2);

    @RequestLine(value="GET /latest/entities/count")
    public long count();
}

