/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts.EntityPartRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts.WebpageRepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.parts.WebpageImpl;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl<E extends Entity>
extends EntityPartRepositoryImpl<Webpage, E>
implements WebpageRepository<E> {
    @Autowired
    private WebpageRepositoryEndpoint endpoint;

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public Webpage create() {
        return new WebpageImpl();
    }

    @Override
    public PageResponse<Webpage> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<Webpage> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public Webpage findOne(UUID uuid) {
        return this.endpoint.findOne(uuid);
    }

    @Override
    public Webpage findOne(UUID uuid, Locale locale) {
        return this.endpoint.findOne(uuid, locale.toString());
    }

    public List<Webpage> getChildren(UUID uuid) {
        return this.endpoint.getChildren(uuid);
    }

    public List<Webpage> getChildren(Webpage webpage) {
        return this.getChildren(webpage.getUuid());
    }

    public Webpage getParent(UUID uuid) {
        return this.endpoint.getParent(uuid);
    }

    @Override
    public Webpage save(Webpage identifiable) {
        return this.endpoint.save(identifiable);
    }

    public Webpage saveWithParentWebpage(Webpage webpage, UUID parentWebpageUUID) {
        return this.endpoint.saveWithParentWebpage(webpage, parentWebpageUUID);
    }

    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUUID) {
        return this.endpoint.saveWithParentWebsite(webpage, parentWebsiteUUID);
    }

    @Override
    public Webpage update(Webpage identifiable) {
        return this.endpoint.update(identifiable.getUuid(), identifiable);
    }
}

