/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.impl.identifiable.IdentifiableImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifiableRepositoryImpl<I extends Identifiable>
implements IdentifiableRepository<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableRepositoryImpl.class);
    @Autowired
    private IdentifiableRepositoryEndpoint endpoint;

    public long count() {
        return this.endpoint.count();
    }

    public I create() {
        return (I)new IdentifiableImpl();
    }

    public PageResponse<I> find(PageRequest pageRequest) {
        FindParams f = this.getFindParams(pageRequest);
        PageResponse<Identifiable> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    public List<I> find(String searchTerm, int maxResults) {
        return this.convertToGenericList(this.endpoint.find(searchTerm, maxResults));
    }

    protected FindParams getFindParams(PageRequest pageRequest) {
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        Sorting sorting = pageRequest.getSorting();
        Iterator iterator = sorting.iterator();
        String sortField = "";
        String sortDirection = "";
        String nullHandling = "";
        if (iterator.hasNext()) {
            Order order = (Order)iterator.next();
            sortField = order.getProperty() == null ? "" : order.getProperty();
            sortDirection = order.getDirection() == null ? "" : order.getDirection().name();
            nullHandling = order.getNullHandling() == null ? "" : order.getNullHandling().name();
        }
        return new FindParams(pageNumber, pageSize, sortField, sortDirection, nullHandling);
    }

    protected PageResponse<I> getGenericPageResponse(PageResponse pageResponse) {
        PageResponse genericPageResponse;
        if (pageResponse.hasContent()) {
            List content = pageResponse.getContent();
            List<I> genericContent = this.convertToGenericList(content);
            genericPageResponse = pageResponse;
            genericPageResponse.setContent(genericContent);
        } else {
            genericPageResponse = pageResponse;
        }
        return genericPageResponse;
    }

    protected List<I> convertToGenericList(List<Identifiable> identifiables) {
        if (identifiables == null) {
            return null;
        }
        List genericContent = identifiables.stream().map(s -> s).collect(Collectors.toList());
        return genericContent;
    }

    public I findOne(UUID uuid) {
        return (I)this.endpoint.findOne(uuid);
    }

    public I findOne(UUID uuid, Locale locale) {
        return (I)this.endpoint.findOne(uuid, locale.toString());
    }

    public I save(I identifiable) {
        return (I)this.endpoint.save((Identifiable)identifiable);
    }

    public I update(I identifiable) {
        return (I)this.endpoint.update(identifiable.getUuid(), (Identifiable)identifiable);
    }

    public class FindParams {
        final int pageNumber;
        final int pageSize;
        final String sortField;
        final String sortDirection;
        final String nullHandling;

        public FindParams(int pageNumber, int pageSize, String sortField, String sortDirection, String nullHandling) {
            this.pageNumber = pageNumber;
            this.pageSize = pageSize;
            this.sortField = sortField;
            this.sortDirection = sortDirection;
            this.nullHandling = nullHandling;
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public String getSortField() {
            return this.sortField;
        }

        public String getSortDirection() {
            return this.sortDirection;
        }

        public String getNullHandling() {
            return this.nullHandling;
        }
    }
}

