/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.impl.repository.RepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageResponse;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import java.util.LinkedHashSet;
import java.util.UUID;

public interface DigitalObjectRepositoryEndpoint
extends RepositoryEndpoint {
    @RequestLine(value="GET /latest/digitalobjects/count")
    public long count();

    @RequestLine(value="GET /latest/digitalobjects?pageNumber={pageNumber}&pageSize={pageSize}&sortField={sortField}&sortDirection={sortDirection}&nullHandling={nullHandling}")
    public PageResponse<DigitalObject> find(@Param(value="pageNumber") int var1, @Param(value="pageSize") int var2, @Param(value="sortField") String var3, @Param(value="sortDirection") String var4, @Param(value="nullHandling") String var5);

    @RequestLine(value="GET /latest/digitalobjects/{uuid}")
    public DigitalObject findOne(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/digitalobjects/{uuid}?locale={locale}")
    public DigitalObject findOne(@Param(value="uuid") UUID var1, @Param(value="locale") String var2);

    @RequestLine(value="GET /latest/digitalobjects/{uuid}/fileresources")
    public LinkedHashSet<FileResource> getFileResources(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/digitalobjects/{uuid}/fileresources/images")
    public LinkedHashSet<ImageFileResource> getImageFileResources(@Param(value="uuid") UUID var1);

    @RequestLine(value="POST /latest/digitalobjects")
    @Headers(value={"Content-Type: application/json"})
    public DigitalObject save(DigitalObject var1);

    @RequestLine(value="POST /latest/digitalobjects/{uuid}/fileresources")
    public LinkedHashSet<FileResource> saveFileResources(@Param(value="uuid") UUID var1, LinkedHashSet<FileResource> var2);

    @RequestLine(value="PUT /latest/digitalobjects/{uuid}")
    @Headers(value={"Content-Type: application/json"})
    public DigitalObject update(@Param(value="uuid") UUID var1, DigitalObject var2);
}

