/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.DigitalObjectRepositoryEndpoint;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DigitalObjectRepositoryImpl
extends EntityRepositoryImpl<DigitalObject>
implements DigitalObjectRepository {
    @Autowired
    private DigitalObjectRepositoryEndpoint endpoint;

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public DigitalObject create() {
        return new DigitalObjectImpl();
    }

    @Override
    public PageResponse<DigitalObject> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<DigitalObject> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public DigitalObject findOne(UUID uuid) {
        return this.endpoint.findOne(uuid);
    }

    @Override
    public DigitalObject findOne(UUID uuid, Locale locale) {
        return this.endpoint.findOne(uuid, locale.toString());
    }

    public LinkedHashSet<FileResource> getFileResources(DigitalObject digitalObject) {
        return this.getFileResources(digitalObject.getUuid());
    }

    public LinkedHashSet<FileResource> getFileResources(UUID digitalObjectUuid) {
        return this.endpoint.getFileResources(digitalObjectUuid);
    }

    public LinkedHashSet<ImageFileResource> getImageFileResources(UUID uuid) {
        return this.endpoint.getImageFileResources(uuid);
    }

    @Override
    public DigitalObject save(DigitalObject digitalObject) {
        return this.endpoint.save(digitalObject);
    }

    public LinkedHashSet<FileResource> saveFileResources(DigitalObject digitalObject, LinkedHashSet<FileResource> fileResources) {
        return this.saveFileResources(digitalObject.getUuid(), fileResources);
    }

    public LinkedHashSet<FileResource> saveFileResources(UUID digitalObjectUuid, LinkedHashSet<FileResource> fileResources) {
        return this.endpoint.saveFileResources(digitalObjectUuid, fileResources);
    }

    @Override
    public DigitalObject update(DigitalObject digitalObject) {
        return this.endpoint.update(digitalObject.getUuid(), digitalObject);
    }
}

