/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.EntityRepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.EntityRelation;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EntityRepositoryImpl<E extends Entity>
extends IdentifiableRepositoryImpl<E>
implements EntityRepository<E> {
    @Autowired
    private EntityRepositoryEndpoint endpoint;

    public void addRelatedFileresource(E entity, FileResource fileResource) {
        this.addRelatedFileresource(entity.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID entityUuid, UUID fileResourceUuid) {
        this.endpoint.addRelatedFileresource(entityUuid, fileResourceUuid);
    }

    public void addRelation(EntityRelation<E> relation) {
        this.addRelation(relation.getSubject().getUuid(), relation.getPredicate(), relation.getObject().getUuid());
    }

    public void addRelation(UUID subjectEntityUuid, String predicate, UUID objectEntityUuid) {
        this.endpoint.addRelation(subjectEntityUuid, predicate, objectEntityUuid);
    }

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public E create() {
        return (E)new EntityImpl();
    }

    @Override
    public PageResponse<E> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<Entity> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public E findOne(UUID uuid) {
        return (E)this.endpoint.findOne(uuid);
    }

    @Override
    public E findOne(UUID uuid, Locale locale) {
        return (E)this.endpoint.findOne(uuid, locale.toString());
    }

    public LinkedHashSet<FileResource> getRelatedFileResources(E entity) {
        return this.getRelatedFileResources(entity.getUuid());
    }

    public LinkedHashSet<FileResource> getRelatedFileResources(UUID entityUuid) {
        return this.endpoint.getRelatedFileResources(entityUuid);
    }

    public List<EntityRelation> getRelations(E subjectEntity) {
        return this.getRelations(subjectEntity.getUuid());
    }

    public List<EntityRelation> getRelations(UUID subjectEntityUuid) {
        return this.endpoint.getRelations(subjectEntityUuid);
    }

    @Override
    public E save(E identifiable) {
        return (E)this.endpoint.save((Entity)identifiable);
    }

    public LinkedHashSet<FileResource> saveRelatedFileResources(E entity, LinkedHashSet<FileResource> fileResources) {
        return this.saveRelatedFileResources(entity.getUuid(), fileResources);
    }

    public LinkedHashSet<FileResource> saveRelatedFileResources(UUID entityUuid, LinkedHashSet<FileResource> fileResources) {
        return this.endpoint.saveRelatedFileResources(entityUuid, fileResources);
    }

    public List<EntityRelation> saveRelations(List<EntityRelation> relations) {
        return this.endpoint.saveRelations(relations);
    }

    @Override
    public E update(E identifiable) {
        return (E)this.endpoint.update(identifiable.getUuid(), (Entity)identifiable);
    }
}

