/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.impl.repository.RepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageResponse;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;

public interface ContentNodeRepositoryEndpoint
extends RepositoryEndpoint {
    @RequestLine(value="GET /latest/contentnodes/count")
    public long count();

    @RequestLine(value="GET /latest/contentnodes?pageNumber={pageNumber}&pageSize={pageSize}&sortField={sortField}&sortDirection={sortDirection}&nullHandling={nullHandling}")
    public PageResponse<ContentNode> find(@Param(value="pageNumber") int var1, @Param(value="pageSize") int var2, @Param(value="sortField") String var3, @Param(value="sortDirection") String var4, @Param(value="nullHandling") String var5);

    @RequestLine(value="GET /latest/contentnodes/{uuid}")
    public ContentNode findOne(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/contentnodes/{uuid}?locale={locale}")
    public ContentNode findOne(@Param(value="uuid") UUID var1, @Param(value="locale") String var2);

    @RequestLine(value="GET /latest/contentnodes/{uuid}/children")
    public List<ContentNode> getChildren(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/contentnodes/{uuid}/entities")
    public LinkedHashSet<Entity> getEntities(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/contentnodes/{uuid}/fileresources")
    public LinkedHashSet<FileResource> getFileResources(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/contentnodes/{uuid}/parent")
    public ContentNode getParent(@Param(value="uuid") UUID var1);

    @RequestLine(value="POST /latest/contentnodes")
    @Headers(value={"Content-Type: application/json"})
    public ContentNode save(ContentNode var1);

    @RequestLine(value="POST /latest/contentnodes/{uuid}/entities")
    @Headers(value={"Content-Type: application/json"})
    public LinkedHashSet<Entity> saveEntities(@Param(value="uuid") UUID var1, LinkedHashSet<Entity> var2);

    @RequestLine(value="POST /latest/contentnodes/{uuid}/fileresources")
    @Headers(value={"Content-Type: application/json"})
    public LinkedHashSet<FileResource> saveFileResources(@Param(value="uuid") UUID var1, LinkedHashSet<FileResource> var2);

    @RequestLine(value="POST /latest/contenttrees/{parentContentTreeUuid}/contentnode")
    @Headers(value={"Content-Type: application/json"})
    public ContentNode saveWithParentContentTree(ContentNode var1, @Param(value="parentContentTreeUuid") UUID var2);

    @RequestLine(value="POST /latest/contentnodes/{parentContentNodeUuid}/contentnode")
    @Headers(value={"Content-Type: application/json"})
    public ContentNode saveWithParentContentNode(ContentNode var1, @Param(value="parentContentNodeUuid") UUID var2);

    @RequestLine(value="PUT /latest/contentnodes/{uuid}")
    @Headers(value={"Content-Type: application/json"})
    public ContentNode update(@Param(value="uuid") UUID var1, ContentNode var2);
}

