/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.ContentNodeRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts.ContentNodeRepositoryEndpoint;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts.EntityPartRepositoryImpl;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.parts.ContentNodeImpl;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ContentNodeRepositoryImpl<E extends Entity>
extends EntityPartRepositoryImpl<ContentNode, E>
implements ContentNodeRepository<E> {
    @Autowired
    private ContentNodeRepositoryEndpoint endpoint;

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public ContentNode create() {
        return new ContentNodeImpl();
    }

    @Override
    public PageResponse<ContentNode> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<ContentNode> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public ContentNode findOne(UUID uuid) {
        return this.endpoint.findOne(uuid);
    }

    @Override
    public ContentNode findOne(UUID uuid, Locale locale) {
        return this.endpoint.findOne(uuid, locale.toString());
    }

    public LinkedHashSet<E> getEntities(ContentNode contentNode) {
        return this.getEntities(contentNode.getUuid());
    }

    public LinkedHashSet<E> getEntities(UUID contentNodeUuid) {
        return this.convertToGenericLinkedHashSet(this.endpoint.getEntities(contentNodeUuid));
    }

    public LinkedHashSet<FileResource> getFileResources(ContentNode contentNode) {
        return this.getFileResources(contentNode.getUuid());
    }

    public LinkedHashSet<FileResource> getFileResources(UUID contentNodeUuid) {
        return this.endpoint.getFileResources(contentNodeUuid);
    }

    public ContentNode getParent(UUID nodeUuid) {
        return this.endpoint.getParent(nodeUuid);
    }

    @Override
    public ContentNode save(ContentNode contentNode) {
        return this.endpoint.save(contentNode);
    }

    public LinkedHashSet<E> saveEntities(ContentNode contentNode, LinkedHashSet<E> entities) {
        return this.saveEntities(contentNode.getUuid(), entities);
    }

    public LinkedHashSet<E> saveEntities(UUID contentNodeUuid, LinkedHashSet<E> entities) {
        return this.convertToGenericLinkedHashSet(this.endpoint.saveEntities(contentNodeUuid, this.convertFromGenericLinkedHashSet(entities)));
    }

    public LinkedHashSet<FileResource> saveFileResources(ContentNode contentNode, LinkedHashSet<FileResource> fileResources) {
        return this.saveFileResources(contentNode.getUuid(), fileResources);
    }

    public LinkedHashSet<FileResource> saveFileResources(UUID contentNodeUuid, LinkedHashSet<FileResource> fileResources) {
        return this.endpoint.saveFileResources(contentNodeUuid, fileResources);
    }

    @Override
    public ContentNode update(ContentNode contentNode) {
        return this.endpoint.update(contentNode.getUuid(), contentNode);
    }

    public List<ContentNode> getChildren(UUID uuid) {
        return this.endpoint.getChildren(uuid);
    }

    public List<ContentNode> getChildren(ContentNode contentNode) {
        return this.getChildren(contentNode.getUuid());
    }

    public ContentNode saveWithParentContentTree(ContentNode contentNode, UUID parentContentTreeUUID) {
        return this.endpoint.saveWithParentContentTree(contentNode, parentContentTreeUUID);
    }

    public ContentNode saveWithParentContentNode(ContentNode contentNode, UUID parentContentNodeUUID) {
        return this.endpoint.saveWithParentContentNode(contentNode, parentContentNodeUUID);
    }
}

