/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.security;

import de.digitalcollections.cudami.admin.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.security.UserRepositoryEndpoint;
import de.digitalcollections.model.api.http.exceptions.client.ResourceNotFoundException;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.impl.security.UserImpl;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserRepositoryImpl
implements UserRepository<UserImpl> {
    @Autowired
    private UserRepositoryEndpoint endpoint;

    public long count() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public UserImpl create() {
        return new UserImpl();
    }

    public PageResponse<UserImpl> find(PageRequest pageRequest) {
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        Sorting sorting = pageRequest.getSorting();
        Iterator iterator = sorting.iterator();
        String sortField = "";
        String sortDirection = "";
        String nullHandling = "";
        if (iterator.hasNext()) {
            Order order = (Order)iterator.next();
            sortField = order.getProperty() == null ? "" : order.getProperty();
            sortDirection = order.getDirection() == null ? "" : order.getDirection().name();
            nullHandling = order.getNullHandling() == null ? "" : order.getNullHandling().name();
        }
        return this.endpoint.find(pageNumber, pageSize, sortField, sortDirection, nullHandling);
    }

    public List<UserImpl> findAll() {
        PageResponse<UserImpl> response = this.endpoint.find(-1, -1, "", "", "");
        return response.getContent();
    }

    public UserImpl findByEmail(String email) {
        UserImpl user;
        try {
            user = this.endpoint.findByEmail(email);
        }
        catch (ResourceNotFoundException e) {
            user = null;
        }
        return user;
    }

    public List<UserImpl> findActiveAdminUsers() {
        return this.endpoint.findActiveAdminUsers();
    }

    public UserImpl save(UserImpl user) {
        return this.endpoint.save(user);
    }

    public UserImpl update(UserImpl user) {
        return this.endpoint.update(user.getUuid(), user);
    }

    public UserImpl findOne(UUID uuid) {
        return this.endpoint.findOne(uuid);
    }
}

