/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.ContentTreeRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.ContentTreeRepositoryEndpoint;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.entity.ContentTree;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.ContentTreeImpl;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ContentTreeRepositoryImpl
extends EntityRepositoryImpl<ContentTree>
implements ContentTreeRepository {
    @Autowired
    private ContentTreeRepositoryEndpoint endpoint;

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public ContentTree create() {
        return new ContentTreeImpl();
    }

    @Override
    public PageResponse<ContentTree> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<ContentTree> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public ContentTree findOne(UUID uuid) {
        return this.endpoint.findOne(uuid);
    }

    @Override
    public ContentTree findOne(UUID uuid, Locale locale) {
        return this.endpoint.findOne(uuid, locale.toString());
    }

    public List<ContentNode> getRootNodes(ContentTree contentTree) {
        return this.getRootNodes(contentTree.getUuid());
    }

    public List<ContentNode> getRootNodes(UUID uuid) {
        return this.endpoint.getRootNodes(uuid);
    }

    @Override
    public ContentTree save(ContentTree contentTree) {
        return this.endpoint.save(contentTree);
    }

    @Override
    public ContentTree update(ContentTree contentTree) {
        return this.endpoint.update(contentTree.getUuid(), contentTree);
    }
}

