/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.EntityRepositoryEndpoint;
import de.digitalcollections.model.api.http.exceptions.client.ResourceNotFoundException;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.EntityRelation;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EntityRepositoryImpl<E extends Entity>
extends IdentifiableRepositoryImpl<E>
implements EntityRepository<E> {
    @Autowired
    private EntityRepositoryEndpoint endpoint;

    public void addRelatedFileresource(E entity, FileResource fileResource) {
        this.addRelatedFileresource(entity.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID entityUuid, UUID fileResourceUuid) {
        this.endpoint.addRelatedFileresource(entityUuid, fileResourceUuid);
    }

    public void addRelation(EntityRelation<E> relation) {
        this.addRelation(relation.getSubject().getUuid(), relation.getPredicate(), relation.getObject().getUuid());
    }

    public void addRelation(UUID subjectEntityUuid, String predicate, UUID objectEntityUuid) {
        this.endpoint.addRelation(subjectEntityUuid, predicate, objectEntityUuid);
    }

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public E create() {
        return (E)new EntityImpl();
    }

    @Override
    public PageResponse<E> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<Entity> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public SearchPageResponse<E> find(SearchPageRequest searchPageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams((PageRequest)searchPageRequest);
        SearchPageResponse<Entity> pageResponse = this.endpoint.find(searchPageRequest.getQuery(), f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        SearchPageResponse response = (SearchPageResponse)this.getGenericPageResponse((PageResponse)pageResponse);
        response.setQuery(searchPageRequest.getQuery());
        return response;
    }

    @Override
    public List<E> find(String searchTerm, int maxResults) {
        List<Entity> entities = this.endpoint.find(searchTerm, maxResults);
        return entities.stream().map(e -> e).collect(Collectors.toList());
    }

    @Override
    public E findOneByIdentifier(String namespace, String id) {
        try {
            return (E)this.endpoint.findOneByIdentifier(namespace, id);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public E findOneByRefId(long refId) {
        Entity result = null;
        try {
            result = this.endpoint.findOneByRefId(refId);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return (E)result;
    }

    @Override
    public E findOne(UUID uuid) {
        return (E)this.endpoint.findOne(uuid);
    }

    @Override
    public E findOne(UUID uuid, Locale locale) {
        return (E)this.endpoint.findOne(uuid, locale.toString());
    }

    public List<FileResource> getRelatedFileResources(E entity) {
        return this.getRelatedFileResources(entity.getUuid());
    }

    public List<FileResource> getRelatedFileResources(UUID entityUuid) {
        return this.endpoint.getRelatedFileResources(entityUuid);
    }

    public List<EntityRelation> getRelations(E subjectEntity) {
        return this.getRelations(subjectEntity.getUuid());
    }

    public List<EntityRelation> getRelations(UUID subjectEntityUuid) {
        return this.endpoint.getRelations(subjectEntityUuid);
    }

    @Override
    public E save(E identifiable) {
        return (E)this.endpoint.save((Entity)identifiable);
    }

    public List<FileResource> saveRelatedFileResources(E entity, List<FileResource> fileResources) {
        return this.saveRelatedFileResources(entity.getUuid(), fileResources);
    }

    public List<FileResource> saveRelatedFileResources(UUID entityUuid, List<FileResource> fileResources) {
        return this.endpoint.saveRelatedFileResources(entityUuid, fileResources);
    }

    public List<EntityRelation> saveRelations(List<EntityRelation> relations) {
        return this.endpoint.saveRelations(relations);
    }

    @Override
    public E update(E identifiable) {
        return (E)this.endpoint.update(identifiable.getUuid(), (Entity)identifiable);
    }
}

