/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.IdentifierTypeRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifierTypeRepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.IdentifierType;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.impl.identifiable.IdentifierTypeImpl;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifierTypeRepositoryImpl
implements IdentifierTypeRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierTypeRepositoryImpl.class);
    @Autowired
    private IdentifierTypeRepositoryEndpoint endpoint;

    public IdentifierType create() {
        return new IdentifierTypeImpl();
    }

    public PageResponse<IdentifierType> find(PageRequest pageRequest) {
        FindParams f = this.getFindParams(pageRequest);
        PageResponse<IdentifierType> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    protected FindParams getFindParams(PageRequest pageRequest) {
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        Sorting sorting = pageRequest.getSorting();
        Iterator iterator = sorting.iterator();
        String sortField = "";
        String sortDirection = "";
        String nullHandling = "";
        if (iterator.hasNext()) {
            Order order = (Order)iterator.next();
            sortField = order.getProperty() == null ? "" : order.getProperty();
            sortDirection = order.getDirection() == null ? "" : order.getDirection().name();
            nullHandling = order.getNullHandling() == null ? "" : order.getNullHandling().name();
        }
        return new FindParams(pageNumber, pageSize, sortField, sortDirection, nullHandling);
    }

    protected PageResponse<IdentifierType> getGenericPageResponse(PageResponse pageResponse) {
        PageResponse genericPageResponse;
        if (pageResponse.hasContent()) {
            List content = pageResponse.getContent();
            genericPageResponse = pageResponse;
            genericPageResponse.setContent(content);
        } else {
            genericPageResponse = pageResponse;
        }
        return genericPageResponse;
    }

    public IdentifierType findOne(UUID uuid) {
        return this.endpoint.findOne(uuid);
    }

    public IdentifierType save(IdentifierType identifierType) {
        return this.endpoint.save(identifierType);
    }

    public IdentifierType update(IdentifierType identifierType) {
        return this.endpoint.update(identifierType.getUuid(), identifierType);
    }

    private static class FindParams {
        final int pageNumber;
        final int pageSize;
        final String sortField;
        final String sortDirection;
        final String nullHandling;

        public FindParams(int pageNumber, int pageSize, String sortField, String sortDirection, String nullHandling) {
            this.pageNumber = pageNumber;
            this.pageSize = pageSize;
            this.sortField = sortField;
            this.sortDirection = sortDirection;
            this.nullHandling = nullHandling;
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public String getSortField() {
            return this.sortField;
        }

        public String getSortDirection() {
            return this.sortDirection;
        }

        public String getNullHandling() {
            return this.nullHandling;
        }
    }
}

