/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.service.identifiable.entity;

import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.ContentTreeRepository;
import de.digitalcollections.cudami.admin.business.api.service.LocaleService;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.ContentTreeService;
import de.digitalcollections.cudami.model.api.identifiable.Identifiable;
import de.digitalcollections.cudami.model.api.identifiable.entity.ContentTree;
import de.digitalcollections.cudami.model.api.identifiable.resource.ContentNode;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;

@Service
public class ContentTreeServiceImpl
implements ContentTreeService<ContentTree> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentTreeServiceImpl.class);
    @Autowired
    private ContentTreeRepository contentTreeRepository;
    @Autowired
    LocaleService localeService;

    @Override
    public long count() {
        return this.contentTreeRepository.count();
    }

    @Override
    public ContentTree create() {
        ContentTree contentTree = (ContentTree)this.contentTreeRepository.create();
        return contentTree;
    }

    @Override
    public PageResponse<ContentTree> find(PageRequest pageRequest) {
        return this.contentTreeRepository.find(pageRequest);
    }

    @Override
    public ContentTree get(UUID uuid) {
        return (ContentTree)this.contentTreeRepository.findOne(uuid);
    }

    @Override
    @Transactional(readOnly=false)
    public ContentTree save(ContentTree contentTree, Errors results) throws IdentifiableServiceException {
        if (!results.hasErrors()) {
            try {
                contentTree = (ContentTree)this.contentTreeRepository.save((Identifiable)contentTree);
            }
            catch (Exception e) {
                LOGGER.error("Cannot save content tree " + contentTree + ": ", (Throwable)e);
                throw new IdentifiableServiceException(e.getMessage());
            }
        }
        return contentTree;
    }

    @Override
    @Transactional(readOnly=false)
    public ContentTree update(ContentTree contentTree, Errors results) throws IdentifiableServiceException {
        if (!results.hasErrors()) {
            try {
                contentTree = (ContentTree)this.contentTreeRepository.update((Identifiable)contentTree);
            }
            catch (Exception e) {
                LOGGER.error("Cannot update content tree " + contentTree + ": ", (Throwable)e);
                throw new IdentifiableServiceException(e.getMessage());
            }
        }
        return contentTree;
    }

    public void setRepository(ContentTreeRepository contentTreeRepository) {
        this.contentTreeRepository = contentTreeRepository;
    }

    @Override
    public List<ContentNode> getRootNodes(ContentTree contentTree) {
        return this.contentTreeRepository.getRootNodes(contentTree);
    }
}

