/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.validator;

import de.digitalcollections.cudami.admin.business.impl.validator.PasswordsValidatorParams;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.LengthRule;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.RuleResult;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class PasswordsValidator
implements Validator {
    private static final Pattern PATTERN_SPECIAL_CHAR = Pattern.compile(".*[^a-zA-Z0-9]+.*");

    protected boolean containsSpecialChar(String password) {
        Matcher m = PATTERN_SPECIAL_CHAR.matcher(password);
        return m.matches();
    }

    public boolean supports(Class<?> clazz) {
        return PasswordsValidatorParams.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        String password2;
        PasswordsValidatorParams passwords = (PasswordsValidatorParams)target;
        String password1 = passwords.getPassword1();
        if (!ObjectUtils.nullSafeEquals((Object)password1, (Object)(password2 = passwords.getPassword2()))) {
            errors.reject("error.passwords_must_be_equals");
            return;
        }
        String passwordHash = passwords.getPasswordHash();
        if (StringUtils.isEmpty((Object)passwordHash) && StringUtils.isEmpty((Object)password1)) {
            errors.reject("error.passwords_must_be_filled");
            return;
        }
        if (!StringUtils.isEmpty((Object)password1) && password1.length() < 12) {
            errors.reject("error.password_min_length", new Object[]{12}, "Password's minimum length is 12.");
            return;
        }
        PasswordValidator validator = new PasswordValidator(Arrays.asList(new LengthRule(12, 30), new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.Digit, 1)));
        RuleResult result = validator.validate(new PasswordData(password1));
        if (!result.isValid()) {
            errors.reject("error.password_too_weak");
            return;
        }
        if (!this.containsSpecialChar(password1)) {
            errors.reject("error.password_too_weak");
            return;
        }
    }
}

